"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensInspectorService = void 0;
var _public = require("@kbn/expressions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLensInspectorService = inspector => {
  const adapters = (0, _public.createDefaultInspectorAdapters)();
  let overlayRef;
  return {
    getInspectorAdapters: () => adapters,
    inspect: options => {
      overlayRef = inspector.open(adapters, options);
      overlayRef.onClose.then(() => {
        if (overlayRef) {
          overlayRef = undefined;
        }
      });
      return overlayRef;
    },
    closeInspector: async () => {
      var _overlayRef;
      return (_overlayRef = overlayRef) === null || _overlayRef === void 0 ? void 0 : _overlayRef.close();
    }
  };
};
exports.getLensInspectorService = getLensInspectorService;