"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AUTO_APPLY_DISABLED_STORAGE_KEY = void 0;
exports.WorkspacePanelWrapper = WorkspacePanelWrapper;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _utils = require("../../../utils");
var _message_list = require("./message_list");
var _state_management = require("../../../state_management");
var _title = require("./title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/editor_frame_service/editor_frame/workspace_panel/workspace_panel_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AUTO_APPLY_DISABLED_STORAGE_KEY = exports.AUTO_APPLY_DISABLED_STORAGE_KEY = 'autoApplyDisabled';
const unitToCSSUnit = {
  pixels: 'px',
  percentage: '%'
};
const getAspectRatioStyles = ({
  x,
  y
}) => {
  return {
    aspectRatio: `${x}/${y}`,
    ...(y > x ? {
      height: '100%',
      width: 'auto'
    } : {
      height: 'auto',
      width: '100%'
    })
  };
};
function WorkspacePanelWrapper({
  children,
  isFullscreen,
  getUserMessages,
  displayOptions
}) {
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const changesApplied = (0, _state_management.useLensSelector)(_state_management.selectChangesApplied);
  const autoApplyEnabled = (0, _state_management.useLensSelector)(_state_management.selectAutoApplyEnabled);
  const userMessages = getUserMessages('toolbar');
  const aspectRatio = displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.aspectRatio;
  const maxDimensions = displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.maxDimensions;
  const minDimensions = displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.minDimensions;
  let visDimensionsCSS = {};
  if (aspectRatio) {
    visDimensionsCSS = getAspectRatioStyles(aspectRatio !== null && aspectRatio !== void 0 ? aspectRatio : maxDimensions);
  }
  if (maxDimensions) {
    visDimensionsCSS.maxWidth = maxDimensions.x ? `${maxDimensions.x.value}${unitToCSSUnit[maxDimensions.x.unit]}` : '';
    visDimensionsCSS.maxHeight = maxDimensions.y ? `${maxDimensions.y.value}${unitToCSSUnit[maxDimensions.y.unit]}` : '';
  }
  if (minDimensions) {
    visDimensionsCSS.minWidth = minDimensions.x ? `${minDimensions.x.value}${unitToCSSUnit[minDimensions.x.unit]}` : '';
    visDimensionsCSS.minHeight = minDimensions.y ? `${minDimensions.y.value}${unitToCSSUnit[minDimensions.y.unit]}` : '';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    direction: "column",
    offset: 0,
    minHeight: 0,
    restrictWidth: false,
    mainProps: {
      component: 'div'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, !(isFullscreen && (autoApplyEnabled || userMessages !== null && userMessages !== void 0 && userMessages.length)) && /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "none",
    color: "transparent",
    className: "hide-for-sharing",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "s",
    direction: "row",
    css: (0, _react2.css)`
              margin-bottom: ${euiTheme.size.m};
              ${isFullscreen && `
                background-color: ${euiTheme.colors.emptyShade};
                justify-content: flex-end;
                margin-bottom: 0;
                padding: ${euiTheme.size.s} ${euiTheme.size.s} 0;
              `}
            `,
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }, userMessages !== null && userMessages !== void 0 && userMessages.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_message_list.MessageList, {
    messages: userMessages,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 21
    }
  })) : null, !autoApplyEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: autoApplyEnabled || changesApplied,
    fill: true,
    className: 'lnsWorkspacePanelWrapper__applyButton ' + _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    iconType: "checkInCircleFilled",
    onClick: () => dispatchLens((0, _state_management.applyChanges)()),
    size: "m",
    "data-test-subj": "lnsApplyChanges__toolbar",
    minWidth: "auto",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.editorFrame.applyChangesLabel",
    defaultMessage: "Apply changes",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 23
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    grow: true,
    paddingSize: "none",
    contentProps: {
      className: 'lnsWorkspacePanelWrapper__content'
    },
    className: (0, _classnames.default)('lnsWorkspacePanelWrapper stretch-for-sharing'),
    css: (0, _react2.css)`
          height: 100%;
          margin-bottom: ${euiTheme.size.base};
          display: flex;
          flex-direction: column;
          position: relative; // For positioning the dnd overlay
          min-height: 400px;
          overflow: visible;
          height: 100%;

          .lnsWorkspacePanelWrapper__content {
            width: 100%;
            height: 100%;
            position: absolute;
          }
          ${isFullscreen && `
            margin-bottom: 0;
            .lnsWorkspacePanelWrapper__content {
              padding: ${euiTheme.size.s}
            }
          `}
        `,
    color: "transparent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "center",
    direction: "column",
    className: "lnsWorkspacePanelWrapper__contentFlexGroup",
    css: (0, _react2.css)`
            height: 100%;
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "lnsWorkspacePanelWrapper__innerContent",
    grow: false,
    css: {
      flexGrow: 0,
      height: '100%',
      width: '100%',
      overflow: 'auto',
      ...visDimensionsCSS
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_title.WorkspaceTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }), children))));
}