"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationToolbarWrapper = void 0;
var _react = require("react");
var _state_management = require("../../state_management");
var _editor_frame_service_context = require("../editor_frame_service_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VisualizationToolbarWrapper = exports.VisualizationToolbarWrapper = /*#__PURE__*/(0, _react.memo)(function VisualizationToolbar({
  framePublicAPI,
  isInlineEditing = false
}) {
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const lensVisualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const visualizationState = (0, _state_management.useLensSelector)(_state_management.selectVisualizationState);
  const {
    visualizationMap
  } = (0, _editor_frame_service_context.useEditorFrameService)();
  const activeVisualization = lensVisualization.activeId ? visualizationMap[lensVisualization.activeId] : null;
  const setVisualizationState = (0, _react.useCallback)(newState => {
    if (!activeVisualization) {
      return;
    }
    dispatchLens((0, _state_management.updateVisualizationState)({
      visualizationId: activeVisualization.id,
      newState
    }));
  }, [dispatchLens, activeVisualization]);
  if (!activeVisualization || !visualizationState) {
    return null;
  }
  const {
    FlyoutToolbarComponent
  } = activeVisualization;
  if (!FlyoutToolbarComponent) {
    return null;
  }
  return FlyoutToolbarComponent({
    frame: framePublicAPI,
    state: visualizationState.state,
    setState: setVisualizationState,
    isInlineEditing
  });
});