"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildExpression = buildExpression;
exports.getDatasourceExpressionsByLayers = getDatasourceExpressionsByLayers;
var _interpreter = require("@kbn/interpreter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDatasourceExpressionsByLayers(datasourceMap, datasourceStates, indexPatterns, dateRange, nowInstant, searchSessionId, forceDSL) {
  const datasourceExpressions = [];
  Object.entries(datasourceMap).forEach(([datasourceId, datasource]) => {
    var _datasourceStates$dat;
    const state = (_datasourceStates$dat = datasourceStates[datasourceId]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state;
    if (!state) {
      return;
    }
    const layers = datasource.getLayers(state);
    layers.forEach(layerId => {
      const result = datasource.toExpression(state, layerId, indexPatterns, dateRange, nowInstant, searchSessionId, forceDSL);
      if (result) {
        datasourceExpressions.push([layerId, result]);
      }
    });
  });
  if (datasourceExpressions.length === 0) {
    return undefined;
  }
  return datasourceExpressions.reduce((exprs, [layerId, expr]) => ({
    ...exprs,
    [layerId]: typeof expr === 'string' ? (0, _interpreter.fromExpression)(expr) : expr
  }), {});
}
function buildExpression({
  visualization,
  visualizationState,
  datasourceMap,
  datasourceStates,
  datasourceLayers,
  title,
  description,
  indexPatterns,
  dateRange,
  nowInstant,
  searchSessionId,
  forceDSL
}) {
  // if an unregistered visualization is passed in the SO
  // then this will be set as "undefined". Relax the check to catch both
  if (visualization == null) {
    return null;
  }
  const datasourceExpressionsByLayers = getDatasourceExpressionsByLayers(datasourceMap, datasourceStates, indexPatterns, dateRange, nowInstant, searchSessionId, forceDSL);
  const visualizationExpression = visualization.toExpression(visualizationState, datasourceLayers, {
    title,
    description
  }, datasourceExpressionsByLayers);
  if (!datasourceExpressionsByLayers || visualizationExpression === null) {
    return null;
  }
  return typeof visualizationExpression === 'string' ? (0, _interpreter.fromExpression)(visualizationExpression) : visualizationExpression;
}