"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_TIME_SCALE = void 0;
exports.adjustTimeScaleLabelSuffix = adjustTimeScaleLabelSuffix;
var _i18n = require("@kbn/i18n");
var _suffix_formatter = require("../../../../common/suffix_formatter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIME_SCALE = exports.DEFAULT_TIME_SCALE = 's';
function getSuffix(scale, shift, reducedTimeRange) {
  return (shift || scale ? ' ' : '') + (scale ? _suffix_formatter.unitSuffixesLong[scale] : '') + (shift && scale ? ' ' : '') + (shift ? `-${shift}` : '') + (reducedTimeRange ? ' ' : '') + (reducedTimeRange ? _i18n.i18n.translate('xpack.lens.reducedTimeRangeSuffix', {
    defaultMessage: 'last {reducedTimeRange}',
    values: {
      reducedTimeRange
    }
  }) : '');
}
function adjustTimeScaleLabelSuffix(oldLabel, previousTimeScale, newTimeScale, previousShift, newShift, previousReducedTimeRange, newReducedTimeRange) {
  let cleanedLabel = oldLabel;
  // remove added suffix if column had a time scale previously
  if (previousTimeScale || previousShift || previousReducedTimeRange) {
    const suffix = getSuffix(previousTimeScale, previousShift, previousReducedTimeRange);
    const suffixPosition = oldLabel.lastIndexOf(suffix);
    if (suffixPosition !== -1) {
      cleanedLabel = oldLabel.substring(0, suffixPosition);
    }
  }
  if (!newTimeScale && !newShift && !newReducedTimeRange) {
    return cleanedLabel;
  }
  // add new suffix if column has a time scale now
  return `${cleanedLabel}${getSuffix(newTimeScale, newShift, newReducedTimeRange)}`;
}