"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DimensionEditor = DimensionEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _operations = require("../operations");
var _state_helpers = require("../state_helpers");
var _pure_utils = require("../pure_utils");
var _utils = require("../utils");
var _bucket_nesting_editor = require("./bucket_nesting_editor");
var _format_selector = require("./format_selector");
var _reference_editor = require("./reference_editor");
var _time_scaling = require("./time_scaling");
var _filtering = require("./filtering");
var _reduced_time_range = require("./reduced_time_range");
var _advanced_options = require("./advanced_options");
var _time_shift = require("./time_shift");
var _constants = require("../../../../common/constants");
var _dimensions_editor_helpers = require("./dimensions_editor_helpers");
var _field_input = require("./field_input");
var _help_popover = require("../help_popover");
var _helpers = require("../operations/definitions/helpers");
var _shared_styles = require("./shared_styles");
var _document_field = require("../document_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/dimension_panel/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const operationDisplay = (0, _operations.getOperationDisplay)();
function getHelpMessage(flag) {
  return flag && typeof flag !== 'boolean' ? flag.helpMessage : null;
}
function DimensionEditor(props) {
  var _state$layers$layerId, _operationDefinitionM, _selectedOperationDef2, _paramEditorCustomPro, _operationDefinitionM2, _operationDefinitionM3;
  const {
    selectedColumn,
    operationSupportMatrix,
    state,
    columnId,
    setState,
    layerId,
    currentIndexPattern,
    hideGrouping,
    dateRange,
    dimensionGroups,
    toggleFullscreen,
    isFullscreen,
    supportStaticValue,
    enableFormatSelector = true,
    layerType,
    paramEditorCustomProps
  } = props;
  const services = {
    data: props.data,
    fieldFormats: props.fieldFormats,
    uiSettings: props.uiSettings,
    http: props.http,
    storage: props.storage,
    unifiedSearch: props.unifiedSearch,
    dataViews: props.dataViews
  };
  const {
    fieldByOperation,
    operationWithoutField
  } = operationSupportMatrix;
  const selectedOperationDefinition = selectedColumn && _operations.operationDefinitionMap[selectedColumn.operationType];
  const [temporaryState, setTemporaryState] = (0, _react.useState)('none');

  // If a layer has sampling disabled, assume the toast has already fired in the past
  const [hasRandomSamplingToastFired, setSamplingToastAsFired] = (0, _react.useState)(!(0, _utils.isSamplingValueEnabled)(state.layers[layerId]));
  const [hasRankingToastFired, setRankingToastAsFired] = (0, _react.useState)(false);
  const [hasOtherBucketToastFired, setHasOtherBucketToastFired] = (0, _react.useState)(false);
  const temporaryQuickFunction = Boolean(temporaryState === _dimensions_editor_helpers.quickFunctionsName);
  const temporaryStaticValue = Boolean(temporaryState === _dimensions_editor_helpers.staticValueOperationName);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const updateLayer = (0, _react.useCallback)(newLayer => setState(prevState => (0, _state_helpers.mergeLayer)({
    state: prevState,
    layerId,
    newLayer
  })), [layerId, setState]);
  const fireOrResetOtherBucketToast = (0, _react.useCallback)(newLayer => {
    if ((0, _dimensions_editor_helpers.isLayerChangingDueToOtherBucketChange)(state.layers[layerId], newLayer)) {
      props.notifications.toasts.add({
        title: _i18n.i18n.translate('xpack.lens.uiInfo.otherBucketChangeTitle', {
          defaultMessage: '“Group remaining values as Other” disabled'
        }),
        text: _i18n.i18n.translate('xpack.lens.uiInfo.otherBucketDisabled', {
          defaultMessage: 'Values >= 1000 may slow performance. Re-enable the setting in “Advanced” options.'
        })
      });
    }
    // resets the flag
    setHasOtherBucketToastFired(!hasOtherBucketToastFired);
  }, [layerId, props.notifications.toasts, state.layers, hasOtherBucketToastFired]);
  const fireOrResetRandomSamplingToast = (0, _react.useCallback)(newLayer => {
    // if prev and current sampling state is different, show a toast to the user
    if ((0, _utils.isSamplingValueEnabled)(state.layers[layerId]) && !(0, _utils.isSamplingValueEnabled)(newLayer)) {
      if (newLayer.sampling != null && newLayer.sampling < 1) {
        props.notifications.toasts.add({
          title: _i18n.i18n.translate('xpack.lens.uiInfo.samplingDisabledTitle', {
            defaultMessage: 'Layer sampling changed to 100%'
          }),
          text: _i18n.i18n.translate('xpack.lens.uiInfo.samplingDisabledMessage', {
            defaultMessage: 'The use of a maximum or minimum function on a layer requires all documents to be sampled in order to function properly.'
          })
        });
      }
    }
    // reset the flag if the user switches to another supported operation
    setSamplingToastAsFired(!hasRandomSamplingToastFired);
  }, [hasRandomSamplingToastFired, layerId, props.notifications.toasts, state.layers]);
  const fireOrResetRankingToast = (0, _react.useCallback)(newLayer => {
    if ((0, _dimensions_editor_helpers.isLayerChangingDueToDecimalsPercentile)(state.layers[layerId], newLayer)) {
      props.notifications.toasts.add({
        title: _i18n.i18n.translate('xpack.lens.uiInfo.rankingResetTitle', {
          defaultMessage: 'Ranking changed to alphabetical'
        }),
        text: _i18n.i18n.translate('xpack.lens.uiInfo.rankingResetToAlphabetical', {
          defaultMessage: 'To rank by percentile, use whole numbers only.'
        })
      });
    }
    // reset the flag if the user switches to another supported operation
    setRankingToastAsFired(!hasRankingToastFired);
  }, [hasRankingToastFired, layerId, props.notifications.toasts, state.layers]);
  const fireOrResetToastChecks = (0, _react.useCallback)(newLayer => {
    fireOrResetRandomSamplingToast(newLayer);
    fireOrResetRankingToast(newLayer);
    fireOrResetOtherBucketToast(newLayer);
  }, [fireOrResetRandomSamplingToast, fireOrResetRankingToast, fireOrResetOtherBucketToast]);
  const setStateWrapper = (0, _react.useCallback)((setter, options = {}) => {
    const layer = state.layers[layerId];
    let hypotethicalLayer;
    if ((0, _helpers.isColumn)(setter)) {
      hypotethicalLayer = {
        ...layer,
        columns: {
          ...layer.columns,
          [columnId]: setter
        }
      };
    } else {
      hypotethicalLayer = typeof setter === 'function' ? setter(state.layers[layerId]) : setter;
    }
    const isDimensionComplete = Boolean(hypotethicalLayer.columns[columnId]);
    setState(prevState => {
      let outputLayer;
      const prevLayer = prevState.layers[layerId];
      if ((0, _helpers.isColumn)(setter)) {
        outputLayer = {
          ...prevLayer,
          columns: {
            ...prevLayer.columns,
            [columnId]: setter
          }
        };
      } else {
        outputLayer = typeof setter === 'function' ? setter(prevState.layers[layerId]) : setter;
      }
      const newLayer = (0, _operations.adjustColumnReferencesForChangedColumn)(outputLayer, columnId);
      // Fire an info toast (eventually) on layer update
      fireOrResetToastChecks(newLayer);
      return (0, _state_helpers.mergeLayer)({
        state: prevState,
        layerId,
        newLayer
      });
    }, {
      isDimensionComplete,
      ...options
    });
  }, [columnId, fireOrResetToastChecks, layerId, setState, state.layers]);
  const incompleteInfo = ((_state$layers$layerId = state.layers[layerId].incompleteColumns) !== null && _state$layers$layerId !== void 0 ? _state$layers$layerId : {})[columnId];
  const {
    operationType: incompleteOperation,
    sourceField: incompleteField = null,
    ...incompleteParams
  } = incompleteInfo || {};
  const isQuickFunctionSelected = Boolean(supportStaticValue ? selectedOperationDefinition && (0, _dimensions_editor_helpers.isQuickFunction)(selectedOperationDefinition.type) : !selectedOperationDefinition || (0, _dimensions_editor_helpers.isQuickFunction)(selectedOperationDefinition.type));
  const showQuickFunctions = temporaryQuickFunction || isQuickFunctionSelected;
  const showStaticValueFunction = temporaryStaticValue || temporaryState === 'none' && supportStaticValue && (!selectedColumn || (selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) === _dimensions_editor_helpers.staticValueOperationName);
  const addStaticValueColumn = (prevLayer = props.state.layers[props.layerId]) => {
    if ((selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) !== _dimensions_editor_helpers.staticValueOperationName) {
      var _props$activeData, _props$activeData$lay, _props$activeData$lay2;
      const layer = (0, _operations.insertOrReplaceColumn)({
        layer: prevLayer,
        indexPattern: currentIndexPattern,
        columnId,
        op: _dimensions_editor_helpers.staticValueOperationName,
        visualizationGroups: dimensionGroups
      });
      const value = (_props$activeData = props.activeData) === null || _props$activeData === void 0 ? void 0 : (_props$activeData$lay = _props$activeData[layerId]) === null || _props$activeData$lay === void 0 ? void 0 : (_props$activeData$lay2 = _props$activeData$lay.rows[0]) === null || _props$activeData$lay2 === void 0 ? void 0 : _props$activeData$lay2[columnId];
      // replace the default value with the one from the active data
      if (value != null) {
        var _props$activeData2, _props$activeData2$la, _props$activeData2$la2;
        return (0, _operations.updateDefaultLabels)((0, _operations.updateColumnParam)({
          layer,
          columnId,
          paramName: 'value',
          value: (_props$activeData2 = props.activeData) === null || _props$activeData2 === void 0 ? void 0 : (_props$activeData2$la = _props$activeData2[layerId]) === null || _props$activeData2$la === void 0 ? void 0 : (_props$activeData2$la2 = _props$activeData2$la.rows[0]) === null || _props$activeData2$la2 === void 0 ? void 0 : _props$activeData2$la2[columnId]
        }), currentIndexPattern);
      }
      return layer;
    }
    return prevLayer;
  };

  // this function intercepts the state update for static value function
  // and. if in temporary state, it merges the "add new static value column" state with the incoming
  // changes from the static value operation (which has to be a function)
  // Note: it forced a rerender at this point to avoid UI glitches in async updates (another hack upstream)
  // TODO: revisit this once we get rid of updateDatasourceAsync upstream
  const moveDefinitelyToStaticValueAndUpdate = setter => {
    if (temporaryStaticValue) {
      setTemporaryState('none');
    }
    if (typeof setter === 'function') {
      return setState(prevState => {
        const layer = setter(addStaticValueColumn(prevState.layers[layerId]));
        return (0, _state_helpers.mergeLayer)({
          state: prevState,
          layerId,
          newLayer: layer
        });
      }, {
        isDimensionComplete: true,
        forceRender: true
      });
    }
    if ((0, _helpers.isColumn)(setter)) {
      throw new Error('static value should only be updated by the whole layer');
    }
  };
  const ParamEditor = (0, _dimensions_editor_helpers.getParamEditor)(temporaryStaticValue, selectedOperationDefinition, supportStaticValue && !showQuickFunctions);
  const possibleOperations = (0, _react.useMemo)(() => {
    return Object.values(_operations.operationDefinitionMap).filter(({
      hidden
    }) => !hidden).filter(operationDefinition => !('selectionStyle' in operationDefinition) || operationDefinition.selectionStyle !== 'hidden').filter(({
      type
    }) => {
      var _fieldByOperation$get;
      return ((_fieldByOperation$get = fieldByOperation.get(type)) === null || _fieldByOperation$get === void 0 ? void 0 : _fieldByOperation$get.size) || operationWithoutField.has(type);
    }).sort((op1, op2) => {
      return op1.displayName.localeCompare(op2.displayName);
    }).map(def => def.type);
  }, [fieldByOperation, operationWithoutField]);
  const helpPopoverContainer = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    return () => {
      if (helpPopoverContainer.current) {
        _reactDom.default.unmountComponentAtNode(helpPopoverContainer.current);
        document.body.removeChild(helpPopoverContainer.current);
      }
    };
  }, []);
  const currentField = selectedColumn && (0, _pure_utils.hasField)(selectedColumn) && currentIndexPattern.getFieldByName(selectedColumn.sourceField);
  const referencedField = currentField || (0, _pure_utils.getReferencedField)(selectedColumn, currentIndexPattern, state.layers[layerId]);

  // Operations are compatible if they match inputs. They are always compatible in
  // the empty state. Field-based operations are not compatible with field-less operations.
  const operationsWithCompatibility = possibleOperations.map(operationType => {
    var _definition$getUnsupp, _definition$getUnsupp2, _definition$getUnsupp3;
    const definition = _operations.operationDefinitionMap[operationType];
    return {
      operationType,
      compatibleWithCurrentField: (0, _operations.canTransition)({
        layer: state.layers[layerId],
        columnId,
        op: operationType,
        indexPattern: currentIndexPattern,
        field: currentField || undefined,
        filterOperations: props.filterOperations,
        visualizationGroups: dimensionGroups,
        dateRange
      }),
      disabledStatus: definition.getDisabledStatus && definition.getDisabledStatus(props.indexPatterns[state.currentIndexPatternId], state.layers[layerId], layerType),
      compatibleWithSampling: (0, _utils.getSamplingValue)(state.layers[layerId]) === 1 || ((_definition$getUnsupp = (_definition$getUnsupp2 = definition.getUnsupportedSettings) === null || _definition$getUnsupp2 === void 0 ? void 0 : (_definition$getUnsupp3 = _definition$getUnsupp2.call(definition)) === null || _definition$getUnsupp3 === void 0 ? void 0 : _definition$getUnsupp3.sampling) !== null && _definition$getUnsupp !== void 0 ? _definition$getUnsupp : true),
      documentation: definition.quickFunctionDocumentation
    };
  });
  const currentFieldIsInvalid = (0, _react.useMemo)(() => (0, _utils.fieldIsInvalid)(state.layers[layerId], columnId, currentIndexPattern), [state.layers, layerId, columnId, currentIndexPattern]);
  const shouldDisplayDots = temporaryState === 'none' || (selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) != null && (0, _dimensions_editor_helpers.isQuickFunction)(selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType);
  const sideNavItems = operationsWithCompatibility.map(({
    operationType,
    compatibleWithCurrentField,
    disabledStatus,
    compatibleWithSampling,
    documentation
  }) => {
    var _referencedField$part;
    const isActive = Boolean(incompleteOperation === operationType || !incompleteOperation && selectedColumn && selectedColumn.operationType === operationType);
    const partialIcon = compatibleWithCurrentField && (referencedField === null || referencedField === void 0 ? void 0 : (_referencedField$part = referencedField.partiallyApplicableFunctions) === null || _referencedField$part === void 0 ? void 0 : _referencedField$part[operationType]) && /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": `${operationType}-partial-warning`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 448,
        columnNumber: 11
      }
    }, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.lens.indexPattern.helpPartiallyApplicableFunctionLabel', {
        defaultMessage: 'This function may only return partial results, as it is unable to support the full time range of rolled-up historical data.'
      }),
      position: "left",
      size: "s",
      type: "partial",
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 13
      }
    }));
    let label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, operationDisplay[operationType].displayName, partialIcon);
    if (isActive && disabledStatus) {
      label = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: disabledStatus,
        display: "block",
        position: "left",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 473,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "danger",
        size: "s",
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 474,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 475,
          columnNumber: 15
        }
      }, label)));
    } else if (disabledStatus) {
      label = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: disabledStatus,
        display: "block",
        position: "left",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 481,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 482,
          columnNumber: 13
        }
      }, operationDisplay[operationType].displayName));
    } else if (!compatibleWithCurrentField) {
      label = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        alignItems: "center",
        responsive: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 487,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        css: {
          marginRight: euiTheme.size.xs,
          minWidth: 0
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 488,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
                  overflow: hidden;
                  text-overflow: ellipsis;
                  white-space: nowrap;
                `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 489,
          columnNumber: 15
        }
      }, label)), shouldDisplayDots && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 500,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.lens.indexPattern.helpIncompatibleFieldDotLabel', {
          defaultMessage: 'This function is not compatible with the current selected field'
        }),
        position: "left",
        size: "s",
        type: "dot",
        color: euiTheme.colors.warning,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 501,
          columnNumber: 17
        }
      })));
    } else if (!compatibleWithSampling) {
      label = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        alignItems: "center",
        responsive: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 517,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        css: {
          marginRight: euiTheme.size.xs
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 518,
          columnNumber: 13
        }
      }, label), shouldDisplayDots && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 522,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.lens.indexPattern.settingsSamplingUnsupported', {
          defaultMessage: `Selecting this function will change this layer's sampling to 100% in order to function properly.`
        }),
        size: "s",
        type: "dot",
        color: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 523,
          columnNumber: 17
        }
      })));
    }
    return {
      id: operationType,
      label,
      isActive,
      size: 's',
      isDisabled: !!disabledStatus,
      css: (0, _shared_styles.operationsButtonStyles)(euiThemeContext),
      'data-test-subj': `lns-indexPatternDimension-${operationType}${compatibleWithCurrentField ? '' : ' incompatible'}`,
      [`aria-pressed`]: isActive,
      extraAction: _operations.operationDefinitionMap[operationType].helpComponent ? {
        color: 'primary',
        onClick: e => {
          if (!helpPopoverContainer.current) {
            const container = document.createElement('div');
            helpPopoverContainer.current = container;
            document.body.appendChild(container);
            const HelpComponent = _operations.operationDefinitionMap[operationType].helpComponent;
            const element = /*#__PURE__*/_react.default.createElement(_help_popover.WrappingHelpPopover, {
              button: e.target,
              isOpen: true,
              title: _operations.operationDefinitionMap[operationType].helpComponentTitle,
              closePopover: () => {
                if (helpPopoverContainer.current) {
                  _reactDom.default.unmountComponentAtNode(helpPopoverContainer.current);
                  document.body.removeChild(helpPopoverContainer.current);
                  helpPopoverContainer.current = null;
                }
              },
              startServices: props.core,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 558,
                columnNumber: 21
              }
            }, /*#__PURE__*/_react.default.createElement(HelpComponent, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 571,
                columnNumber: 23
              }
            }));
            _reactDom.default.render(element, helpPopoverContainer.current);
          } else {
            _reactDom.default.unmountComponentAtNode(helpPopoverContainer.current);
            document.body.removeChild(helpPopoverContainer.current);
            helpPopoverContainer.current = null;
          }
        },
        iconType: 'documentation',
        iconSize: 's',
        'aria-label': _i18n.i18n.translate('xpack.lens.indexPattern.helpLabel', {
          defaultMessage: 'Function help'
        })
      } : undefined,
      showToolTip: !disabledStatus,
      toolTipProps: {
        position: 'left'
      },
      toolTipText: documentation,
      onClick() {
        if (['none', 'fullReference', 'managedReference'].includes(_operations.operationDefinitionMap[operationType].input)) {
          // Clear invalid state because we are reseting to a valid column
          if ((selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) === operationType) {
            if (incompleteInfo) {
              setStateWrapper((0, _operations.resetIncomplete)(state.layers[layerId], columnId));
            }
            return;
          }
          const newLayer = (0, _operations.insertOrReplaceColumn)({
            layer: props.state.layers[props.layerId],
            indexPattern: currentIndexPattern,
            columnId,
            op: operationType,
            visualizationGroups: dimensionGroups,
            targetGroup: props.groupId
          });
          if (temporaryQuickFunction && (0, _dimensions_editor_helpers.isQuickFunction)(newLayer.columns[columnId].operationType)) {
            // Only switch the tab once the "non quick function" is fully removed
            setTemporaryState('none');
          }
          setStateWrapper(newLayer);
          return;
        } else if (!selectedColumn || !compatibleWithCurrentField) {
          var _fieldByOperation$get2;
          const possibleFields = (_fieldByOperation$get2 = fieldByOperation.get(operationType)) !== null && _fieldByOperation$get2 !== void 0 ? _fieldByOperation$get2 : new Set();
          let newLayer;
          if (possibleFields.size === 1) {
            newLayer = (0, _operations.insertOrReplaceColumn)({
              layer: props.state.layers[props.layerId],
              indexPattern: currentIndexPattern,
              columnId,
              op: operationType,
              field: currentIndexPattern.getFieldByName(possibleFields.values().next().value),
              visualizationGroups: dimensionGroups,
              targetGroup: props.groupId
            });
          } else {
            newLayer = (0, _operations.insertOrReplaceColumn)({
              layer: props.state.layers[props.layerId],
              indexPattern: currentIndexPattern,
              columnId,
              op: operationType,
              // if document field can be used, default to it
              field: possibleFields.has(_constants.DOCUMENT_FIELD_NAME) ? _document_field.documentField : undefined,
              visualizationGroups: dimensionGroups,
              targetGroup: props.groupId
            });
          }
          if (temporaryQuickFunction && (0, _dimensions_editor_helpers.isQuickFunction)(newLayer.columns[columnId].operationType)) {
            // Only switch the tab once the "non quick function" is fully removed
            setTemporaryState('none');
          }
          setStateWrapper(newLayer);
          return;
        }
        if (selectedColumn.operationType === operationType) {
          if (incompleteInfo) {
            setStateWrapper((0, _operations.resetIncomplete)(state.layers[layerId], columnId));
          }
          return;
        }
        if (temporaryQuickFunction) {
          setTemporaryState('none');
        }
        const newLayer = (0, _operations.replaceColumn)({
          layer: props.state.layers[props.layerId],
          indexPattern: currentIndexPattern,
          columnId,
          op: operationType,
          field: (0, _pure_utils.hasField)(selectedColumn) ? currentIndexPattern.getFieldByName(selectedColumn.sourceField) : undefined,
          visualizationGroups: dimensionGroups
        });
        setStateWrapper(newLayer);
      }
    };
  });
  const shouldDisplayExtraOptions = !currentFieldIsInvalid && !incompleteInfo && selectedColumn && (0, _dimensions_editor_helpers.isQuickFunction)(selectedColumn.operationType) && ParamEditor;
  const shouldDisplayReferenceEditor = !incompleteInfo && selectedColumn && 'references' in selectedColumn && (selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.input) === 'fullReference';
  const shouldDisplayFieldInput = !selectedColumn || (selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.input) === 'field' || incompleteOperation && ((_operationDefinitionM = _operations.operationDefinitionMap[incompleteOperation]) === null || _operationDefinitionM === void 0 ? void 0 : _operationDefinitionM.input) === 'field' || temporaryQuickFunction;
  const FieldInputComponent = (selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : selectedOperationDefinition.renderFieldInput) || _field_input.FieldInput;
  const paramEditorProps = {
    layer: state.layers[layerId],
    layerId,
    activeData: props.activeData,
    paramEditorUpdater: setter => {
      if (temporaryQuickFunction) {
        setTemporaryState('none');
      }
      setStateWrapper(setter, {
        forceRender: temporaryQuickFunction
      });
    },
    columnId,
    currentColumn: state.layers[layerId].columns[columnId],
    dateRange,
    indexPattern: currentIndexPattern,
    operationDefinitionMap: _operations.operationDefinitionMap,
    toggleFullscreen,
    isFullscreen,
    paramEditorCustomProps,
    ReferenceEditor: _reference_editor.ReferenceEditor,
    dataSectionExtra: props.dataSectionExtra,
    ...services
  };
  const quickFunctions = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 738,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 739,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.lens.indexPattern.functionsLabel', {
      defaultMessage: 'Functions'
    }))),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 736,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    css: sideNavItems.length > 3 ? operationsTwoColumnsStyles(euiThemeContext) : undefined,
    gutterSize: "none",
    color: "primary",
    listItems:
    // add a padding item containing a non breakable space if the number of operations is not even
    // otherwise the column layout will break within an element
    sideNavItems.length % 2 === 1 ? [...sideNavItems, {
      label: '\u00a0'
    }] : sideNavItems,
    maxWidth: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 748,
      columnNumber: 9
    }
  })), shouldDisplayReferenceEditor ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedColumn.references.map((referenceId, index) => {
    var _selectedOperationDef;
    const validation = selectedOperationDefinition.requiredReferences[index];
    const layer = state.layers[layerId];
    return /*#__PURE__*/_react.default.createElement(_reference_editor.ReferenceEditor, (0, _extends2.default)({
      operationDefinitionMap: _operations.operationDefinitionMap,
      key: index,
      layer: layer,
      layerId: layerId,
      activeData: props.activeData,
      columnId: referenceId,
      column: layer.columns[referenceId],
      incompleteColumn: layer.incompleteColumns ? layer.incompleteColumns[referenceId] : undefined,
      onResetIncomplete: () => {
        updateLayer({
          ...layer,
          // clean up the incomplete column data for the referenced id
          incompleteColumns: {
            ...layer.incompleteColumns,
            [referenceId]: undefined
          }
        });
      },
      onDeleteColumn: () => {
        updateLayer((0, _operations.deleteColumn)({
          layer,
          columnId: referenceId,
          indexPattern: currentIndexPattern
        }));
      },
      onChooseFunction: (operationType, field) => {
        const newLayer = (0, _operations.insertOrReplaceColumn)({
          layer,
          columnId: referenceId,
          op: operationType,
          indexPattern: currentIndexPattern,
          field,
          visualizationGroups: dimensionGroups
        });
        fireOrResetToastChecks(newLayer);
        updateLayer(newLayer);
      },
      onChooseField: choice => {
        updateLayer((0, _operations.insertOrReplaceColumn)({
          layer,
          columnId: referenceId,
          indexPattern: currentIndexPattern,
          op: choice.operationType,
          field: currentIndexPattern.getFieldByName(choice.field),
          visualizationGroups: dimensionGroups
        }));
      },
      paramEditorUpdater: setter => {
        let newLayer;
        if (typeof setter === 'function') {
          newLayer = setter(layer);
        } else if ((0, _helpers.isColumn)(setter)) {
          newLayer = {
            ...layer,
            columns: {
              ...layer.columns,
              [referenceId]: setter
            }
          };
        } else {
          newLayer = setter;
        }
        fireOrResetToastChecks(newLayer);
        return updateLayer((0, _operations.adjustColumnReferencesForChangedColumn)(newLayer, referenceId));
      },
      validation: validation,
      currentIndexPattern: currentIndexPattern,
      selectionStyle: selectedOperationDefinition.selectionStyle,
      dateRange: dateRange,
      labelAppend: selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : (_selectedOperationDef = selectedOperationDefinition.getHelpMessage) === null || _selectedOperationDef === void 0 ? void 0 : _selectedOperationDef.call(selectedOperationDefinition, {
        data: props.data,
        uiSettings: props.uiSettings,
        currentColumn: layer.columns[columnId]
      }),
      isFullscreen: isFullscreen,
      toggleFullscreen: toggleFullscreen,
      paramEditorCustomProps: paramEditorCustomProps
    }, services, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 767,
        columnNumber: 15
      }
    }));
  }), selectedOperationDefinition.selectionStyle !== 'field' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 857,
      columnNumber: 69
    }
  }) : null) : null, shouldDisplayFieldInput ? /*#__PURE__*/_react.default.createElement(FieldInputComponent, {
    layer: state.layers[layerId],
    selectedColumn: selectedColumn,
    columnId: columnId,
    indexPattern: currentIndexPattern,
    operationSupportMatrix: operationSupportMatrix,
    updateLayer: newLayer => {
      if (temporaryQuickFunction) {
        setTemporaryState('none');
      }
      setStateWrapper(newLayer, {
        forceRender: temporaryQuickFunction
      });
    },
    incompleteField: incompleteField,
    incompleteOperation: incompleteOperation,
    incompleteParams: incompleteParams,
    currentFieldIsInvalid: currentFieldIsInvalid,
    helpMessage: selectedOperationDefinition === null || selectedOperationDefinition === void 0 ? void 0 : (_selectedOperationDef2 = selectedOperationDefinition.getHelpMessage) === null || _selectedOperationDef2 === void 0 ? void 0 : _selectedOperationDef2.call(selectedOperationDefinition, {
      data: props.data,
      uiSettings: props.uiSettings,
      currentColumn: state.layers[layerId].columns[columnId]
    }),
    dimensionGroups: dimensionGroups,
    groupId: props.groupId,
    operationDefinitionMap: _operations.operationDefinitionMap,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 862,
      columnNumber: 9
    }
  }) : null, !isFullscreen && !incompleteInfo && !hideGrouping && temporaryState === 'none' && /*#__PURE__*/_react.default.createElement(_bucket_nesting_editor.BucketNestingEditor, {
    layer: state.layers[props.layerId],
    columnId: props.columnId,
    setColumns: columnOrder => updateLayer({
      columnOrder
    }),
    getFieldByName: currentIndexPattern.getFieldByName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 889,
      columnNumber: 9
    }
  }), shouldDisplayExtraOptions && /*#__PURE__*/_react.default.createElement(ParamEditor, (0, _extends2.default)({}, paramEditorProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 897,
      columnNumber: 37
    }
  })), !(selectedOperationDefinition !== null && selectedOperationDefinition !== void 0 && selectedOperationDefinition.handleDataSectionExtra) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 900,
      columnNumber: 11
    }
  }), props.dataSectionExtra));
  const customParamEditor = ParamEditor ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ParamEditor, (0, _extends2.default)({
    layer: state.layers[layerId],
    activeData: props.activeData,
    paramEditorUpdater: temporaryStaticValue ? moveDefinitelyToStaticValueAndUpdate : setStateWrapper,
    columnId: columnId,
    currentColumn: state.layers[layerId].columns[columnId],
    operationDefinitionMap: _operations.operationDefinitionMap,
    layerId: layerId,
    paramEditorCustomProps: paramEditorCustomProps,
    dateRange: dateRange,
    isFullscreen: isFullscreen,
    indexPattern: currentIndexPattern,
    toggleFullscreen: toggleFullscreen,
    ReferenceEditor: _reference_editor.ReferenceEditor
  }, services, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 909,
      columnNumber: 7
    }
  }))) : null;
  const ButtonGroupContent = showQuickFunctions ? quickFunctions : customParamEditor;
  const onFormatChange = (0, _react.useCallback)(newFormat => {
    updateLayer((0, _operations.updateColumnParam)({
      layer: state.layers[layerId],
      columnId,
      paramName: 'format',
      value: newFormat
    }));
  }, [columnId, layerId, state.layers, updateLayer]);
  const hasFormula = !isFullscreen && operationSupportMatrix.operationWithoutField.has(_dimensions_editor_helpers.formulaOperationName);
  const hasButtonGroups = !isFullscreen && (hasFormula || supportStaticValue);
  const initialMethod = (0, _react.useMemo)(() => {
    let methodId = '';
    if (showStaticValueFunction) {
      methodId = _dimensions_editor_helpers.staticValueOperationName;
    } else if (showQuickFunctions) {
      methodId = _dimensions_editor_helpers.quickFunctionsName;
    } else if (temporaryState === 'none' && (selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) === _dimensions_editor_helpers.formulaOperationName) {
      methodId = _dimensions_editor_helpers.formulaOperationName;
    }
    return methodId;
  }, [selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType, showQuickFunctions, showStaticValueFunction, temporaryState]);
  const [selectedMethod, setSelectedMethod] = (0, _react.useState)(initialMethod);
  const options = [{
    id: _dimensions_editor_helpers.staticValueOperationName,
    enabled: Boolean(supportStaticValue),
    state: showStaticValueFunction,
    onClick: () => {
      if ((selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) === _dimensions_editor_helpers.formulaOperationName) {
        return setTemporaryState(_dimensions_editor_helpers.staticValueOperationName);
      }
      setTemporaryState('none');
      setStateWrapper(addStaticValueColumn());
      return;
    },
    label: _i18n.i18n.translate('xpack.lens.indexPattern.staticValueLabel', {
      defaultMessage: 'Static value'
    })
  }, {
    id: _dimensions_editor_helpers.quickFunctionsName,
    enabled: true,
    state: showQuickFunctions,
    onClick: () => {
      if (selectedColumn && !(0, _dimensions_editor_helpers.isQuickFunction)(selectedColumn.operationType)) {
        setTemporaryState(_dimensions_editor_helpers.quickFunctionsName);
        return;
      }
    },
    label: _i18n.i18n.translate('xpack.lens.indexPattern.quickFunctionsLabel', {
      defaultMessage: 'Quick function'
    })
  }, {
    id: _dimensions_editor_helpers.formulaOperationName,
    enabled: hasFormula,
    state: temporaryState === 'none' && (selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) === _dimensions_editor_helpers.formulaOperationName,
    onClick: () => {
      setTemporaryState('none');
      if ((selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType) !== _dimensions_editor_helpers.formulaOperationName) {
        const newLayer = (0, _operations.insertOrReplaceColumn)({
          layer: props.state.layers[props.layerId],
          indexPattern: currentIndexPattern,
          columnId,
          op: _dimensions_editor_helpers.formulaOperationName,
          visualizationGroups: dimensionGroups
        });
        setStateWrapper(newLayer);
      }
    },
    label: _i18n.i18n.translate('xpack.lens.indexPattern.formulaLabel', {
      defaultMessage: 'Formula'
    })
  }];
  const defaultLabel = (0, _react.useMemo)(() => String(selectedColumn && _operations.operationDefinitionMap[selectedColumn.operationType].getDefaultLabel(selectedColumn, state.layers[layerId].columns, props.indexPatterns[state.layers[layerId].indexPatternId])), [layerId, selectedColumn, props.indexPatterns, state.layers]);

  /**
   * Advanced options can cause side effects on other columns (i.e. formulas)
   * so before updating the layer the full insertOrReplaceColumn needs to be performed
   */
  const updateAdvancedOption = (0, _react.useCallback)(newLayer => {
    if (selectedColumn) {
      setStateWrapper(
      // formula need to regenerate from scratch
      selectedColumn.operationType === _dimensions_editor_helpers.formulaOperationName ? (0, _operations.insertOrReplaceColumn)({
        op: selectedColumn.operationType,
        layer: newLayer,
        columnId,
        indexPattern: currentIndexPattern,
        visualizationGroups: dimensionGroups
      }) : newLayer);
    }
  }, [columnId, currentIndexPattern, dimensionGroups, selectedColumn, setStateWrapper]);
  const shouldDisplayAdvancedOptions = !isFullscreen && !currentFieldIsInvalid && !incompleteInfo && selectedColumn && temporaryState === 'none' && selectedOperationDefinition && (selectedOperationDefinition.timeScalingMode || selectedOperationDefinition.filterable || selectedOperationDefinition.shiftable);
  return /*#__PURE__*/_react.default.createElement("div", {
    id: columnId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1069,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1070,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
            margin-bottom: ${euiTheme.size.base};
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1071,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1077,
      columnNumber: 11
    }
  }, (_paramEditorCustomPro = paramEditorCustomProps === null || paramEditorCustomProps === void 0 ? void 0 : paramEditorCustomProps.headingLabel) !== null && _paramEditorCustomPro !== void 0 ? _paramEditorCustomPro : _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingData', {
    defaultMessage: 'Data'
  }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasButtonGroups ? /*#__PURE__*/_react.default.createElement(_dimensions_editor_helpers.DimensionEditorButtonGroups, {
    options: options,
    onMethodChange: optionId => {
      setSelectedMethod(optionId);
    },
    selectedMethod: selectedMethod,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1086,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_dimensions_editor_helpers.CalloutWarning, {
    currentOperationType: selectedColumn === null || selectedColumn === void 0 ? void 0 : selectedColumn.operationType,
    temporaryStateType: temporaryState,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1094,
      columnNumber: 11
    }
  }), ButtonGroupContent)), shouldDisplayAdvancedOptions && /*#__PURE__*/_react.default.createElement(_advanced_options.AdvancedOptions, {
    options: [{
      dataTestSubj: 'indexPattern-time-scaling-enable',
      inlineElement: selectedOperationDefinition.timeScalingMode ? /*#__PURE__*/_react.default.createElement(_time_scaling.TimeScaling, {
        selectedColumn: selectedColumn,
        columnId: columnId,
        layer: state.layers[layerId],
        updateLayer: updateAdvancedOption,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1108,
          columnNumber: 17
        }
      }) : null
    }, {
      dataTestSubj: 'indexPattern-filter-by-enable',
      inlineElement: selectedOperationDefinition.filterable ? /*#__PURE__*/_react.default.createElement(_filtering.Filtering, {
        indexPattern: currentIndexPattern,
        selectedColumn: selectedColumn,
        columnId: columnId,
        layer: state.layers[layerId],
        updateLayer: updateAdvancedOption,
        helpMessage: getHelpMessage(selectedOperationDefinition.filterable),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1119,
          columnNumber: 17
        }
      }) : null
    }, {
      dataTestSubj: 'indexPattern-reducedTimeRange-enable',
      inlineElement: selectedOperationDefinition.canReduceTimeRange ? /*#__PURE__*/_react.default.createElement(_reduced_time_range.ReducedTimeRange, {
        selectedColumn: selectedColumn,
        columnId: columnId,
        indexPattern: currentIndexPattern,
        layer: state.layers[layerId],
        updateLayer: updateAdvancedOption,
        skipLabelUpdate: hasFormula,
        helpMessage: getHelpMessage(selectedOperationDefinition.canReduceTimeRange),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1132,
          columnNumber: 17
        }
      }) : null
    }, {
      dataTestSubj: 'indexPattern-time-shift-enable',
      inlineElement: Boolean(selectedOperationDefinition.shiftable && (currentIndexPattern.timeFieldName || Object.values(state.layers[layerId].columns).some(col => col.operationType === 'date_histogram'))) ? /*#__PURE__*/_react.default.createElement(_time_shift.TimeShift, {
        datatableUtilities: services.data.datatableUtilities,
        indexPattern: currentIndexPattern,
        selectedColumn: selectedColumn,
        columnId: columnId,
        layer: state.layers[layerId],
        updateLayer: updateAdvancedOption,
        activeData: props.activeData,
        layerId: layerId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 1152,
          columnNumber: 17
        }
      }) : null
    }, ...(((_operationDefinitionM2 = (_operationDefinitionM3 = _operations.operationDefinitionMap[selectedColumn.operationType]).getAdvancedOptions) === null || _operationDefinitionM2 === void 0 ? void 0 : _operationDefinitionM2.call(_operationDefinitionM3, {
      ...paramEditorProps,
      euiTheme
    })) || [])],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1103,
      columnNumber: 9
    }
  }), !isFullscreen && !currentFieldIsInvalid && /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded lnsIndexPatternDimensionEditor--collapseNext",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1173,
      columnNumber: 9
    }
  }, !incompleteInfo && temporaryState === 'none' && selectedColumn && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                margin-bottom: ${euiTheme.size.base};
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1181,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingAppearance', {
    defaultMessage: 'Appearance'
  }))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !incompleteInfo && selectedColumn && temporaryState === 'none' && /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.NameInput, {
    value: selectedColumn.label,
    defaultValue: defaultLabel,
    onChange: value => {
      updateLayer({
        columns: {
          ...state.layers[layerId].columns,
          [columnId]: {
            ...selectedColumn,
            label: value,
            customLabel: _operations.operationDefinitionMap[selectedColumn.operationType].getDefaultLabel(selectedColumn, state.layers[layerId].columns, props.indexPatterns[state.layers[layerId].indexPatternId]) !== value
          }
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1190,
      columnNumber: 15
    }
  }), enableFormatSelector && !isFullscreen && selectedColumn && (selectedColumn.dataType === 'number' || selectedColumn.operationType === 'range') ? /*#__PURE__*/_react.default.createElement(_format_selector.FormatSelector, {
    selectedColumn: selectedColumn,
    onChange: onFormatChange,
    docLinks: props.core.docLinks,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 1217,
      columnNumber: 15
    }
  }) : null)));
}
const operationsTwoColumnsStyles = ({
  euiTheme
}) => {
  return (0, _react2.css)`
    display: block;
    column-count: 2;
    column-gap: ${euiTheme.size.m};
  `;
};