"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsMenu = SettingsMenu;
exports.toggleSettingsMenuOpen = toggleSettingsMenuOpen;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-utils-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _state_management = require("../state_management");
var _settings_storage = require("../settings_storage");
var _workspace_panel_wrapper = require("../editor_frame_service/editor_frame/workspace_panel/workspace_panel_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/settings_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const container = document.createElement('div');
let isMenuOpen = false;

// exported for testing purposes only
function SettingsMenu({
  anchorElement,
  isOpen,
  onClose
}) {
  const autoApplyEnabled = (0, _state_management.useLensSelector)(_state_management.selectAutoApplyEnabled);
  const dispatch = (0, _state_management.useLensDispatch)();
  const toggleAutoApply = (0, _react.useCallback)(() => {
    (0, _settings_storage.writeToStorage)(new _public.Storage(localStorage), _workspace_panel_wrapper.AUTO_APPLY_DISABLED_STORAGE_KEY, String(autoApplyEnabled));
    dispatch(autoApplyEnabled ? (0, _state_management.disableAutoApply)() : (0, _state_management.enableAutoApply)());
  }, [dispatch, autoApplyEnabled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    "data-test-subj": "lnsApp__settingsMenu",
    ownFocus: true,
    button: anchorElement,
    closePopover: onClose,
    isOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.settings.title",
    defaultMessage: "Lens settings",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.lens.settings.autoApply', {
      defaultMessage: 'Auto-apply visualization changes'
    }),
    checked: autoApplyEnabled,
    onChange: () => toggleAutoApply(),
    "data-test-subj": "lnsToggleAutoApply",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
}
function closeSettingsMenu() {
  _reactDom.default.unmountComponentAtNode(container);
  document.body.removeChild(container);
  isMenuOpen = false;
}

/**
 * Toggles the settings menu
 *
 * Note: the code inside this function is covered only at the functional test level
 */
function toggleSettingsMenuOpen(props) {
  if (isMenuOpen) {
    closeSettingsMenu();
    return;
  }
  isMenuOpen = true;
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, props.startServices, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: props.lensStore,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SettingsMenu, (0, _extends2.default)({}, props, {
    isOpen: isMenuOpen,
    onClose: closeSettingsMenu,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }))));
  _reactDom.default.render(element, container);
}