"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromBasicMetricAPItoLensState = fromBasicMetricAPItoLensState;
exports.fromBasicMetricLensStateToAPI = fromBasicMetricLensStateToAPI;
exports.fromSumMetricAPIToLensState = fromSumMetricAPIToLensState;
exports.fromSumMetricLensStateToAPI = fromSumMetricLensStateToAPI;
var _format = require("./format");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function fromBasicMetricAPItoLensState(options) {
  const {
    field,
    format
  } = options;
  return {
    operationType: options.operation,
    sourceField: field,
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    ...(format ? {
      params: {
        format: (0, _format.fromFormatAPIToLensState)(format)
      }
    } : {})
  };
}
function fromSumMetricAPIToLensState(options) {
  const {
    field,
    format,
    empty_as_null
  } = options;
  return {
    operationType: 'sum',
    sourceField: field,
    ...(0, _utils.getLensStateMetricSharedProps)(options),
    params: {
      emptyAsNull: Boolean(empty_as_null),
      ...(format ? {
        format: (0, _format.fromFormatAPIToLensState)(format)
      } : {})
    }
  };
}
function fromBasicMetricLensStateToAPI(options) {
  var _options$params;
  return {
    operation: options.operationType,
    field: options.sourceField,
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params = options.params) !== null && _options$params !== void 0 && _options$params.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
}
function fromSumMetricLensStateToAPI(options) {
  var _options$params2, _options$params3;
  return {
    operation: 'sum',
    field: options.sourceField,
    empty_as_null: Boolean((_options$params2 = options.params) === null || _options$params2 === void 0 ? void 0 : _options$params2.emptyAsNull),
    ...(0, _utils.getLensAPIMetricSharedProps)(options),
    ...((_options$params3 = options.params) !== null && _options$params3 !== void 0 && _options$params3.format ? {
      format: (0, _format.fromFormatLensStateToAPI)(options.params.format)
    } : {})
  };
}