"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionStateSchema = exports.lensApiStateSchema = exports._lensApiStateSchema = void 0;
Object.defineProperty(exports, "regionMapStateSchema", {
  enumerable: true,
  get: function () {
    return _region_map.regionMapStateSchema;
  }
});
Object.defineProperty(exports, "tagcloudStateSchema", {
  enumerable: true,
  get: function () {
    return _tagcloud.tagcloudStateSchema;
  }
});
var _configSchema = require("@kbn/config-schema");
var _metric = require("./charts/metric");
var _legacy_metric = require("./charts/legacy_metric");
var _gauge = require("./charts/gauge");
var _heatmap = require("./charts/heatmap");
var _tagcloud = require("./charts/tagcloud");
var _xy = require("./charts/xy");
var _mosaic = require("./charts/mosaic");
var _pie = require("./charts/pie");
var _treemap = require("./charts/treemap");
var _waffle = require("./charts/waffle");
var _region_map = require("./charts/region_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const partitionStateSchema = exports.partitionStateSchema = _configSchema.schema.oneOf([_mosaic.mosaicStateSchema, _pie.pieStateSchema, _treemap.treemapStateSchema, _waffle.waffleStateSchema]);
/**
 * We need to break the type inference here to avoid exceeding the ts compiler serialization limit.
 *
 * This requires:
 *  - Casting the schema as any
 *  - Defining the `LensApiState` type from the schema types
 *  - Exporting this value as `Type<LensApiState>`
 */
const _lensApiStateSchema = exports._lensApiStateSchema = _configSchema.schema.oneOf([_metric.metricStateSchema, _legacy_metric.legacyMetricStateSchema, _xy.xyStateSchema, _gauge.gaugeStateSchema, _heatmap.heatmapStateSchema, _tagcloud.tagcloudStateSchema,
// disable for now to avoid type issues at the config builder root level
// TODO: enabled once transformations are available
// partitionStateSchema,
_region_map.regionMapStateSchema]);
const lensApiStateSchema = exports.lensApiStateSchema = _lensApiStateSchema;