"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.datasetTypeSchema = exports.datasetSchema = exports.datasetEsqlTableTypeSchema = exports.datasetEsqlTableSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const datasetTypeSchema = exports.datasetTypeSchema = _configSchema.schema.oneOf([
// DataView dataset type
_configSchema.schema.object({
  type: _configSchema.schema.literal('dataView'),
  /**
   * The name of the Kibana data view to use as the data source.
   * Example: 'my-data-view'
   */
  id: _configSchema.schema.string({
    meta: {
      description: 'The id of the Kibana data view to use as the data source. Example: "my-data-view".'
    }
  })
}),
// Index dataset type
_configSchema.schema.object({
  type: _configSchema.schema.literal('index'),
  /**
   * The name of the Elasticsearch index to use as the data source.
   * Example: 'my-index-*'
   */
  index: _configSchema.schema.string({
    meta: {
      description: 'The name of the Elasticsearch index to use as the data source. Example: "my-index-*".'
    }
  }),
  /**
   * The name of the time field in the index. Used for time-based filtering.
   * Example: '@timestamp'
   */
  time_field: _configSchema.schema.string({
    meta: {
      description: 'The name of the time field in the index. Used for time-based filtering. Example: "@timestamp".'
    }
  }),
  /**
   * Optional array of runtime fields to define on the index. Each runtime field describes a computed field available at query time.
   * If not provided, no runtime fields are used.
   */
  runtime_fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    /**
     * The type of the runtime field (e.g., 'keyword', 'long', 'date').
     * Example: 'keyword'
     */
    type: _configSchema.schema.string({
      meta: {
        description: 'The type of the runtime field (e.g., "keyword", "long", "date").'
      }
    }),
    /**
     * The name of the runtime field.
     * Example: 'my_runtime_field'
     */
    name: _configSchema.schema.string({
      meta: {
        description: 'The name of the runtime field. Example: "my_runtime_field".'
      }
    }),
    /**
     * Optional format definition for the runtime field. The structure depends on the field type and use case.
     * If not provided, no format is applied.
     */
    format: _configSchema.schema.maybe(_configSchema.schema.any({
      meta: {
        description: 'Optional format definition for the runtime field. Structure depends on field type.'
      }
    }))
  })))
})]);
const datasetSchema = exports.datasetSchema = {
  /**
   * The dataset configuration. Can be one of the following types:
   * - `dataView`: Use a Kibana data view as the data source. Requires a `name` property with the name of the data view.
   * - `index`: Use a Elasticsearch index as the data source. Requires an `index` property with the name of the index, and optionally a `time_field` property with the name of the time field in the index.
   * - `esql`: Use an ESQL query string as the data source. Requires a `query` property with the ESQL query string.
   * - `table`: Use a Kibana datatable object as the data source. Requires a `table` property with the Kibana datatable object, which should match the Kibana Datatable contract.
   */
  dataset: datasetTypeSchema
};
const datasetEsqlTableTypeSchema = exports.datasetEsqlTableTypeSchema = _configSchema.schema.oneOf([
// ESQL dataset type
_configSchema.schema.object({
  type: _configSchema.schema.literal('esql'),
  /**
   * The ESQL query string to use as the data source.
   * Example: 'FROM my-index | LIMIT 100'
   */
  query: _configSchema.schema.string({
    meta: {
      description: 'The ESQL query string to use as the data source. Example: "FROM my-index | LIMIT 100".'
    }
  })
}),
// Table dataset type
_configSchema.schema.object({
  type: _configSchema.schema.literal('table'),
  /**
   * The Kibana datatable object to use as the data source. The structure should match the Kibana Datatable contract.
   */
  table: _configSchema.schema.any({
    meta: {
      description: 'The Kibana datatable object to use as the data source. Structure should match the Kibana Datatable contract.'
    }
  })
})]);
const datasetEsqlTableSchema = exports.datasetEsqlTableSchema = {
  dataset: datasetEsqlTableTypeSchema
};
const anyDatasetSchema = _configSchema.schema.oneOf([datasetTypeSchema, datasetEsqlTableTypeSchema]);