"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waffleStateSharedSchema = exports.waffleStateSchemaNoESQL = exports.waffleStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _color = require("../color");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _partition_shared = require("./partition_shared");
var _shared2 = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Shared visualization options for partition charts including legend and value display
 */
const waffleStateSharedSchema = exports.waffleStateSharedSchema = {
  legend: _configSchema.schema.maybe(_configSchema.schema.object({
    values: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('absolute')], {
      meta: {
        description: 'Legend value display mode: absolute (show raw metric values in legend)'
      }
    }), {
      minSize: 1,
      maxSize: 1
    })),
    truncate_after_lines: _partition_shared.legendTruncateAfterLinesSchema,
    visible: _partition_shared.legendVisibleSchema,
    size: _partition_shared.legendSizeSchema
  }, {
    meta: {
      description: 'Legend configuration for waffle chart'
    }
  })),
  value_display: _partition_shared.valueDisplaySchema
};

/**
 * Color configuration for primary metric in waffle chart
 */
const partitionStatePrimaryMetricOptionsSchema = _configSchema.schema.object({
  color: _configSchema.schema.maybe(_color.staticColorSchema)
});

/**
 * Breakdown configuration including color mapping and collapse behavior
 */
const partitionStateBreakdownByOptionsSchema = _configSchema.schema.object({
  color: _configSchema.schema.maybe(_configSchema.schema.oneOf([_color.colorByValueSchema, _color.colorMappingSchema], {
    meta: {
      description: 'Color configuration: by value (palette-based) or mapping (custom rules)'
    }
  })),
  collapse_by: _configSchema.schema.maybe(_shared.collapseBySchema)
});
function validateGroupings({
  metrics,
  group_by
}) {
  var _group_by$filter$leng2;
  if (metrics.length > 1) {
    var _group_by$filter$leng;
    if (((_group_by$filter$leng = group_by === null || group_by === void 0 ? void 0 : group_by.filter(def => def.collapse_by == null).length) !== null && _group_by$filter$leng !== void 0 ? _group_by$filter$leng : 0) > 0) {
      return 'When multiple metrics are defined, only collapsed breakdown dimensions are allowed.';
    }
  }
  if (((_group_by$filter$leng2 = group_by === null || group_by === void 0 ? void 0 : group_by.filter(def => def.collapse_by == null).length) !== null && _group_by$filter$leng2 !== void 0 ? _group_by$filter$leng2 : 0) > 1) {
    return 'Only a single non-collapsed breakdown dimension is allowed.';
  }
}

/**
 * Waffle chart configuration for standard (non-ES|QL) queries
 */
const waffleStateSchemaNoESQL = exports.waffleStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('waffle'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  ...waffleStateSharedSchema,
  metrics: _configSchema.schema.arrayOf((0, _shared2.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps)(partitionStatePrimaryMetricOptionsSchema), {
    minSize: 1,
    meta: {
      description: 'Array of metric configurations (minimum 1)'
    }
  }),
  group_by: _configSchema.schema.maybe(_configSchema.schema.arrayOf((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(partitionStateBreakdownByOptionsSchema), {
    minSize: 1,
    meta: {
      description: 'Array of breakdown dimensions (minimum 1)'
    }
  }))
}, {
  meta: {
    description: 'Waffle chart configuration for standard queries'
  },
  validate: validateGroupings
});

/**
 * Waffle chart configuration for ES|QL queries
 */
const waffleStateSchemaESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('waffle'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  ...waffleStateSharedSchema,
  metrics: _configSchema.schema.arrayOf(_configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), partitionStatePrimaryMetricOptionsSchema, _metric_ops.esqlColumnSchema], {
    meta: {
      description: 'ES|QL column reference for primary metric'
    }
  })),
  group_by: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.allOf([partitionStateBreakdownByOptionsSchema, _metric_ops.esqlColumnSchema], {
    meta: {
      description: 'ES|QL column reference for breakdown dimension'
    }
  }), {
    minSize: 1,
    meta: {
      description: 'Array of ES|QL breakdown columns (minimum 1)'
    }
  }))
}, {
  meta: {
    description: 'Waffle chart configuration for ES|QL queries'
  },
  validate: validateGroupings
});

/**
 * Complete waffle chart configuration supporting both standard and ES|QL queries
 */
const waffleStateSchema = exports.waffleStateSchema = _configSchema.schema.oneOf([waffleStateSchemaNoESQL, waffleStateSchemaESQL], {
  meta: {
    description: 'Waffle chart configuration: DSL or ES|QL query based'
  }
});