"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.valueDisplaySchema = exports.legendVisibleSchema = exports.legendTruncateAfterLinesSchema = exports.legendSizeSchema = exports.legendNestedSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const legendTruncateAfterLinesSchema = exports.legendTruncateAfterLinesSchema = _configSchema.schema.maybe(_configSchema.schema.number({
  defaultValue: 1,
  min: 1,
  max: 10,
  meta: {
    description: 'Maximum lines before truncating legend items (1-10)'
  }
}));
const legendVisibleSchema = exports.legendVisibleSchema = _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('auto'), _configSchema.schema.literal('show'), _configSchema.schema.literal('hide')], {
  meta: {
    description: 'Legend visibility: auto, show, or hide'
  }
}));
const legendSizeSchema = exports.legendSizeSchema = _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('auto'), _configSchema.schema.literal('small'), _configSchema.schema.literal('medium'), _configSchema.schema.literal('large'), _configSchema.schema.literal('xlarge')], {
  meta: {
    description: 'Legend size: auto, small, medium, large, or xlarge'
  }
}));
const valueDisplaySchema = exports.valueDisplaySchema = _configSchema.schema.maybe(_configSchema.schema.object({
  mode: _configSchema.schema.oneOf([_configSchema.schema.literal('hidden'), _configSchema.schema.literal('absolute'), _configSchema.schema.literal('percentage')], {
    meta: {
      description: 'Value display mode: hidden, absolute, or percentage'
    }
  }),
  percent_decimals: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: 2,
    min: 0,
    max: 10,
    meta: {
      description: 'Decimal places for percentage display (0-10)'
    }
  }))
}, {
  meta: {
    description: 'Configuration for displaying values in chart cells'
  }
}));
const legendNestedSchema = exports.legendNestedSchema = _configSchema.schema.maybe(_configSchema.schema.boolean({
  defaultValue: false,
  meta: {
    description: 'Show nested legend with hierarchical breakdown levels'
  }
}));