"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGauge = buildGauge;
var _types = require("../types");
var _utils = require("../utils");
var _columns = require("../columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'metric_formula_accessor';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function buildVisualizationState(config) {
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    ticksPosition: 'auto',
    shape: layer.shape || 'horizontalBullet',
    labelMajorMode: 'auto',
    metricAccessor: ACCESSOR,
    ...(layer.queryGoalValue ? {
      goalAccessor: getAccessorName('goal')
    } : {}),
    ...(layer.queryMaxValue ? {
      maxAccessor: getAccessorName('max'),
      showBar: true
    } : {}),
    ...(layer.queryMinValue ? {
      minAccessor: getAccessorName('min')
    } : {})
  };
}
function buildFormulaLayer(layer, i, dataView) {
  const layers = {
    [_types.DEFAULT_LAYER_ID]: {
      ...(0, _columns.getFormulaColumn)(ACCESSOR, (0, _utils.mapToFormula)(layer), dataView)
    }
  };
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  if (layer.queryGoalValue) {
    const columnName = getAccessorName('goal');
    const formulaColumn = (0, _columns.getFormulaColumn)(columnName, {
      formula: layer.queryGoalValue
    }, dataView);
    (0, _utils.addLayerFormulaColumns)(defaultLayer, formulaColumn);
  }
  if (layer.queryMinValue) {
    const columnName = getAccessorName('min');
    const formulaColumn = (0, _columns.getFormulaColumn)(columnName, {
      formula: layer.queryMinValue
    }, dataView);
    (0, _utils.addLayerFormulaColumns)(defaultLayer, formulaColumn);
  }
  if (layer.queryMaxValue) {
    const columnName = getAccessorName('max');
    const formulaColumn = (0, _columns.getFormulaColumn)(columnName, {
      formula: layer.queryMaxValue
    }, dataView);
    (0, _utils.addLayerFormulaColumns)(defaultLayer, formulaColumn);
  }
  return defaultLayer;
}
function getValueColumns(layer) {
  return [(0, _columns.getValueColumn)(ACCESSOR, layer.value), ...(layer.queryMaxValue ? [(0, _columns.getValueColumn)(getAccessorName('max'), layer.queryMaxValue)] : []), ...(layer.queryMinValue ? [(0, _columns.getValueColumn)(getAccessorName('min'), layer.queryMinValue)] : []), ...(layer.queryGoalValue ? [(0, _columns.getValueColumn)(getAccessorName('goal'), layer.queryGoalValue)] : [])];
}
async function buildGauge(config, {
  dataViewsAPI
}) {
  const dataviews = {};
  const _buildFormulaLayer = (cfg, i, dataView) => buildFormulaLayer(cfg, i, dataView);
  const datasourceStates = await (0, _utils.buildDatasourceStates)(config, dataviews, _buildFormulaLayer, getValueColumns, dataViewsAPI);
  const {
    references,
    internalReferences,
    adHocDataViews
  } = (0, _utils.extractReferences)(dataviews);
  return {
    title: config.title,
    visualizationType: 'lnsGauge',
    references,
    state: {
      datasourceStates,
      internalReferences,
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: buildVisualizationState(config),
      adHocDataViews
    }
  };
}