"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptDialogService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _intercept_dialog_api = require("./intercept_dialog_api");
var _intercept_display_manager = require("../component/intercept_display_manager");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/intercepts/public/prompter/service/intercept_dialog_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class InterceptDialogService {
  constructor() {
    (0, _defineProperty2.default)(this, "api", new _intercept_dialog_api.InterceptDialogApi());
    (0, _defineProperty2.default)(this, "targetDomElement", void 0);
    (0, _defineProperty2.default)(this, "notificationsCoordinator", void 0);
    (0, _defineProperty2.default)(this, "interceptsStream$", void 0);
  }
  setup({
    analytics,
    notifications
  }) {
    this.api.setup({
      analytics
    });
    this.notificationsCoordinator = notifications.coordinator(InterceptDialogService.name);
    return {};
  }
  start({
    targetDomElement,
    rendering,
    analytics,
    staticAssetsHelper,
    persistInterceptRunId: persistInterceptRunInteraction,
    resetInterceptTimingRecord
  }) {
    const {
      ack,
      add,
      get$
    } = this.api.start({
      analytics
    });
    this.targetDomElement = targetDomElement;
    if (!this.notificationsCoordinator) {
      throw new Error('Notifications coordinator is not initialized');
    }

    // leverages the notifications coordinator to ensure that we are not showing
    // intercepts when the user is interacting with other notifications
    // (e.g. toast notifications)
    this.interceptsStream$ = this.notificationsCoordinator.optInToCoordination(get$(), ({
      locked
    }) => !locked).pipe(Rx.scan((pendingInterceptsQueue, incomingIntercepts) => {
      const pendingInterceptIds = pendingInterceptsQueue.map(intercept => intercept.id);
      const newIncomingIntercepts = incomingIntercepts.filter(intercept => !pendingInterceptIds.includes(intercept.id));

      // Here we only return the new incoming intercepts,
      // because we intend to hold on to all previous intercept values till they can be emitted
      // under the conditions we define
      return newIncomingIntercepts;
    }, []),
    // don't emit on empty
    Rx.filter(pendingInterceptsQueue => Boolean(pendingInterceptsQueue.length)), Rx.concatMap(pendingInterceptsQueue => {
      return Rx.from(pendingInterceptsQueue).pipe(Rx.concatMap(item => this.notificationsCoordinator.lock$.pipe(Rx.filter(lockState => !lockState.locked || lockState.controller === InterceptDialogService.name), Rx.take(1),
      // Wait until the lock is available, then proceed
      Rx.tap(lockState => {
        if (!lockState.locked) {
          this.notificationsCoordinator.acquireLock();
        }
      }), Rx.map(() => item))));
    }));
    const ackIntercept = (...args) => {
      var _this$notificationsCo;
      const [{
        runId,
        ...ackArgs
      }] = args;
      ack(ackArgs);

      // Reset the timer start record, so the next interval starts fresh
      resetInterceptTimingRecord(ackArgs.interceptId);

      // persist the intercept interaction to the user trigger data
      persistInterceptRunInteraction(ackArgs.interceptId, runId);

      // Release acquired lock after user acknowledges the intercept
      // This allows the next queued item in the co-ordination queue (if any) to be processed automatically
      (_this$notificationsCo = this.notificationsCoordinator) === null || _this$notificationsCo === void 0 ? void 0 : _this$notificationsCo.releaseLock();
    };
    (0, _reactDom.render)(rendering.addContext(/*#__PURE__*/_react.default.createElement(_intercept_display_manager.InterceptDisplayManagerMemoized, {
      intercept$: this.interceptsStream$,
      ackIntercept,
      staticAssetsHelper,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    })), this.targetDomElement);
    return {
      add
    };
  }
  stop() {
    if (this.targetDomElement) {
      (0, _reactDom.unmountComponentAtNode)(this.targetDomElement);
    }
  }
}
exports.InterceptDialogService = InterceptDialogService;