"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptDisplayManagerMemoized = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _intercept_display_manager = require("./intercept_display_manager.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/intercepts/public/prompter/component/intercept_display_manager/intercept_display_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InterceptProgressIndicator = /*#__PURE__*/_react.default.memo(({
  stepsTotal,
  currentStep
}) => {
  if (!stepsTotal) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    className: "euiTourFooter__stepList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, [...Array(stepsTotal).keys()].map((_, i) => {
    let status = 'complete';
    if (currentStep === i) {
      status = 'active';
    } else if (currentStep <= i) {
      status = 'incomplete';
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 20
      }
    });
  })));
});
function InterceptDisplayManager({
  ackIntercept,
  intercept$,
  staticAssetsHelper
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [currentStepIndex, setCurrentStepIndex] = (0, _react.useState)(0);
  const [currentIntercept, setCurrentIntercept] = (0, _react.useState)(null);
  const feedbackStore = (0, _react.useRef)({});
  const interceptRenderMark = (0, _react.useRef)();
  const styles = (0, _react.useMemo)(() => (0, _intercept_display_manager.styles)(euiTheme, staticAssetsHelper), [euiTheme, staticAssetsHelper]);
  (0, _react.useEffect)(() => {
    const subscription = intercept$.subscribe(intercept => {
      setCurrentIntercept(intercept);
      setCurrentStepIndex(0); // Reset to first step
      feedbackStore.current = {}; // Clear previous feedback
      interceptRenderMark.current = performance.mark(`intercept-${intercept.id}-RenderMark`);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [intercept$]);
  const handleTerminationInteraction = (0, _react.useCallback)(terminationType => {
    if (!currentIntercept) return null;

    // reset the intercept render state first before acknowledging the intercept,
    // so that we don't have a situation where another intercept is to be displayed,
    // but because we've signaled that a new intercept can be displayed,
    // that intercept gets pushed but then the state reset happens because of the async nature of react state updates,
    // if this happens the coordination lock will be held on to without any way to release it
    setCurrentIntercept(null);
    setCurrentStepIndex(0);
    feedbackStore.current = {};
    switch (terminationType) {
      case 'dismissed':
        {
          var _currentIntercept$onD;
          (_currentIntercept$onD = currentIntercept.onDismiss) === null || _currentIntercept$onD === void 0 ? void 0 : _currentIntercept$onD.call(currentIntercept, {
            runId: currentIntercept.runId,
            stepId: currentIntercept.steps[0].id
          });
          break;
        }
      case 'completed':
        {
          var _currentIntercept$onF;
          (_currentIntercept$onF = currentIntercept.onFinish) === null || _currentIntercept$onF === void 0 ? void 0 : _currentIntercept$onF.call(currentIntercept, {
            response: feedbackStore.current,
            runId: currentIntercept.runId
          });
          break;
        }
      default:
        {
          throw new Error(`Invalid termination type: ${terminationType}`);
        }
    }
    ackIntercept({
      runId: currentIntercept.runId,
      interceptId: currentIntercept.id,
      ackType: terminationType,
      interactionDuration: performance.measure('interceptCompleteMark', {
        start: interceptRenderMark.current.startTime,
        end: performance.now()
      }).duration
    });
  }, [ackIntercept, currentIntercept]);
  const seekNextStep = (0, _react.useCallback)(isLastStep => {
    if (isLastStep) {
      return handleTerminationInteraction('completed');
    }
    setCurrentStepIndex(prevStepIndex => {
      return Math.min(prevStepIndex + 1, currentIntercept.steps.length);
    });
  }, [handleTerminationInteraction, currentIntercept]);
  const dismissProductIntercept = (0, _react.useCallback)(() => {
    return handleTerminationInteraction('dismissed');
  }, [handleTerminationInteraction]);
  const onInterceptStepInput = (0, _react.useCallback)(function (value) {
    var _onProgress, _ref;
    feedbackStore.current[this.id] = value;
    (_onProgress = (_ref = currentIntercept).onProgress) === null || _onProgress === void 0 ? void 0 : _onProgress.call(_ref, {
      stepId: this.id,
      stepResponse: value,
      runId: currentIntercept.runId
    });
    seekNextStep();
  }, [currentIntercept, seekNextStep]);
  const currentInterceptStep = (0, _react.useMemo)(() => {
    var _currentIntercept$ste;
    return currentIntercept === null || currentIntercept === void 0 ? void 0 : (_currentIntercept$ste = currentIntercept.steps) === null || _currentIntercept$ste === void 0 ? void 0 : _currentIntercept$ste[currentStepIndex !== null && currentStepIndex !== void 0 ? currentStepIndex : 0];
  }, [currentIntercept, currentStepIndex]);
  const isLastStep = (0, _react.useMemo)(() => {
    return !!currentIntercept && currentStepIndex === currentIntercept.steps.length - 1;
  }, [currentIntercept, currentStepIndex]);
  const isStartStep = currentStepIndex === 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(currentIntercept && currentInterceptStep) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    role: "dialog",
    css: styles.wrapper,
    "data-test-subj": `intercept-${currentIntercept.id}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    css: (0, _react2.css)([styles.stepContentBox, isStartStep && styles.startIllustration]),
    "data-test-subj": `interceptStep-${currentInterceptStep.id}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    css: (0, _react2.css)({
      ...(isStartStep ? styles.startContentBox : {})
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 25
    }
  }, currentInterceptStep.title))), currentStepIndex > 0 && !isLastStep && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": "Close dialog",
    onClick: dismissProductIntercept,
    color: "text",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(currentInterceptStep.content, {
    onValue: onInterceptStepInput.bind(currentInterceptStep)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    css: styles.stepFooterBox,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(InterceptProgressIndicator, {
    stepsTotal: currentIntercept.steps.length,
    currentStep: currentStepIndex,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 19
    }
  })), (isStartStep || isLastStep) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 21
    }
  }, isStartStep && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "data-test-subj": "productInterceptDismissButton",
    onClick: dismissProductIntercept,
    color: "text",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 27
    }
  }, _i18n.i18n.translate('core.notifications.productIntercept.dismiss', {
    defaultMessage: 'Not now'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "productInterceptProgressionButton",
    onClick: () => seekNextStep(isLastStep),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 25
    }
  }, isLastStep ? _i18n.i18n.translate('core.notifications.productIntercept.nextStep', {
    defaultMessage: 'Close'
  }) : _i18n.i18n.translate('core.notifications.productIntercept.nextStep', {
    defaultMessage: 'Next'
  }))))))))));
}
const InterceptDisplayManagerMemoized = exports.InterceptDisplayManagerMemoized = /*#__PURE__*/_react.default.memo(InterceptDisplayManager);