"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectHighlight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/overlay/inspect_highlight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * InspectHighlight displays a highlight box around the currently
 * inspected HTML element, along with a badge containing the source component display name.
 */
const InspectHighlight = ({
  currentPosition,
  path
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    transform,
    ...rest
  } = currentPosition;
  const containerRef = (0, _react.useRef)(null);
  const badgeRef = (0, _react.useRef)(null);
  const [badgeOffsetX, setBadgeOffsetX] = (0, _react.useState)(0);
  const [badgeOffsetY, setBadgeOffsetY] = (0, _react.useState)(0);
  const isFixed = currentPosition.position === 'fixed';
  const containerCss = (0, _css.css)({
    position: currentPosition.position || 'absolute',
    transform,
    ...(isFixed ? rest : {}),
    pointerEvents: 'none'
  });
  const highlightCss = (0, _css.css)({
    position: 'absolute',
    backgroundColor: (0, _eui.transparentize)(euiTheme.colors.primary, 0.3),
    border: `2px solid ${euiTheme.colors.primary}`,
    pointerEvents: 'none',
    ...(isFixed ? {
      top: 0,
      left: 0,
      right: 0,
      bottom: 0
    } : rest)
  });

  /** This handles repositoning of the hihglight badge so it's always fully visible. */
  (0, _react.useLayoutEffect)(() => {
    if (!badgeRef.current || !containerRef.current) return;
    const badgeRect = badgeRef.current.getBoundingClientRect();
    const containerRect = containerRef.current.getBoundingClientRect();
    const viewportWidth = window.innerWidth;
    const viewportHeight = window.innerHeight;
    const highlightHeight = typeof rest.height === 'number' ? rest.height : parseInt(rest.height || '0', 10);

    /**
     * Horizontal adjustment.
     * If the badge would overflow the viewport on the right, it will get shifted to the left.
     */
    if (isFixed) {
      const badgeRight = containerRect.left + badgeRect.width;
      setBadgeOffsetX(badgeRight > viewportWidth ? viewportWidth - containerRect.left - badgeRect.width : 0);
    } else {
      const availableRight = viewportWidth - containerRect.left;
      setBadgeOffsetX(badgeRect.width > availableRight ? availableRight - badgeRect.width : 0);
    }

    /**
     * Vertical adjustment.
     * If the badge would overflow the viewport on the bottom, it will get fliped above the highlight.
     */
    if (isFixed) {
      // For fixed positioning, the container is already positioned at the exact element location
      // Badge should be positioned relative to the container (which is the highlight itself)
      const containerBottom = containerRect.bottom;
      const badgeWouldBeAt = containerBottom + badgeRect.height;
      if (badgeWouldBeAt > viewportHeight) {
        // Flip above highlight - position at negative badge height
        setBadgeOffsetY(-badgeRect.height);
      } else {
        // Place badge below highlight - position at the height of the highlight box
        const containerHeight = containerRect.height;
        setBadgeOffsetY(containerHeight);
      }
    } else {
      const availableBottom = viewportHeight - (containerRect.top + highlightHeight);
      if (badgeRect.height > availableBottom) {
        setBadgeOffsetY(-badgeRect.height);
      } else {
        setBadgeOffsetY(highlightHeight);
      }
    }
  }, [path, rest.left, rest.top, rest.width, rest.height, currentPosition.position, isFixed]);
  const badgeCss = (0, _css.css)({
    position: 'absolute',
    top: badgeOffsetY,
    left: badgeOffsetX,
    whiteSpace: 'nowrap'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    className: containerCss,
    "data-test-subj": "inspectHighlightContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: highlightCss,
    "data-test-subj": "inspectHighlightBox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), path && /*#__PURE__*/_react.default.createElement("div", {
    ref: badgeRef,
    className: badgeCss,
    "data-test-subj": "inspectHighlightBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, path)));
};
exports.InspectHighlight = InspectHighlight;