"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDeleteModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _deleteManagedAssetCallout = require("@kbn/delete-managed-asset-callout");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/delete_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PipelineDeleteModal = ({
  pipelinesToDelete,
  callback
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const numPipelinesToDelete = pipelinesToDelete.length;
  const managedPipelinesToDelete = pipelinesToDelete.filter(({
    isManaged
  }) => isManaged).length;
  const handleDeletePipelines = () => {
    const pipelineNames = pipelinesToDelete.map(({
      name
    }) => name);
    services.api.deletePipelines(pipelineNames).then(({
      data: {
        itemsDeleted,
        errors
      },
      error
    }) => {
      const hasDeletedPipelines = itemsDeleted && itemsDeleted.length;
      if (hasDeletedPipelines) {
        const successMessage = itemsDeleted.length === 1 ? _i18n.i18n.translate('xpack.ingestPipelines.deleteModal.successDeleteSingleNotificationMessageText', {
          defaultMessage: "Deleted pipeline ''{pipelineName}''",
          values: {
            pipelineName: pipelineNames[0]
          }
        }) : _i18n.i18n.translate('xpack.ingestPipelines.deleteModal.successDeleteMultipleNotificationMessageText', {
          defaultMessage: 'Deleted {numSuccesses, plural, one {# pipeline} other {# pipelines}}',
          values: {
            numSuccesses: itemsDeleted.length
          }
        });
        callback({
          hasDeletedPipelines
        });
        services.notifications.toasts.addSuccess(successMessage);
      }
      if (error || errors !== null && errors !== void 0 && errors.length) {
        const hasMultipleErrors = (errors === null || errors === void 0 ? void 0 : errors.length) > 1 || error && pipelinesToDelete.length > 1;
        const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.ingestPipelines.deleteModal.multipleErrorsNotificationMessageText', {
          defaultMessage: 'Error deleting {count} pipelines',
          values: {
            count: (errors === null || errors === void 0 ? void 0 : errors.length) || pipelinesToDelete.length
          }
        }) : _i18n.i18n.translate('xpack.ingestPipelines.deleteModal.errorNotificationMessageText', {
          defaultMessage: "Error deleting pipeline ''{name}''",
          values: {
            name: errors && errors[0].name || pipelineNames[0]
          }
        });
        services.notifications.toasts.addDanger(errorMessage);
      }
    });
  };
  const handleOnCancel = () => {
    callback();
  };
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    buttonColor: "danger",
    "data-test-subj": "deletePipelinesConfirmation",
    titleProps: {
      id: modalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.deleteModal.modalTitleText",
      defaultMessage: "Delete {numPipelinesToDelete, plural, one {pipeline} other {# pipelines}}",
      values: {
        numPipelinesToDelete
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }),
    onCancel: handleOnCancel,
    onConfirm: handleDeletePipelines,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.deleteModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.deleteModal.confirmButtonLabel",
      defaultMessage: "Delete {numPipelinesToDelete, plural, one {pipeline} other {pipelines} }",
      values: {
        numPipelinesToDelete
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, managedPipelinesToDelete > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_deleteManagedAssetCallout.DeleteManagedAssetsCallout, {
    assetName: _i18n.i18n.translate('xpack.ingestPipelines.deleteModal.assetName', {
      defaultMessage: 'ingest pipelines'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.deleteModal.deleteDescription",
    defaultMessage: "You are about to delete {numPipelinesToDelete, plural, one {this pipeline} other {these pipelines} }:",
    values: {
      numPipelinesToDelete
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, pipelinesToDelete.map(({
    name,
    isManaged
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, name, ' ', isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.ingestPipelines.deleteModal.managedPipelineLabel', {
    defaultMessage: 'Managed'
  })))))));
};
exports.PipelineDeleteModal = PipelineDeleteModal;