"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectReferences = exports.extractReferences = exports.LOG_VIEW_REFERENCE_NAME = void 0;
var _common = require("@kbn/logs-shared-plugin/common");
var _server = require("@kbn/logs-shared-plugin/server");
var _log_threshold = require("@kbn/response-ops-rule-params/log_threshold");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_VIEW_REFERENCE_NAME = exports.LOG_VIEW_REFERENCE_NAME = 'log-view-reference-0';
const extractReferences = params => {
  if (!_common.logViewReferenceRT.is(params.logView)) {
    return {
      params,
      references: []
    };
  }
  const references = [{
    name: LOG_VIEW_REFERENCE_NAME,
    type: _server.logViewSavedObjectName,
    id: params.logView.logViewId
  }];
  const newParams = {
    ...params,
    logView: {
      ...params.logView,
      logViewId: LOG_VIEW_REFERENCE_NAME
    }
  };
  return {
    params: newParams,
    references
  };
};
exports.extractReferences = extractReferences;
const injectReferences = (params, references) => {
  const decodedParams = _log_threshold.logThresholdParamsSchema.validate(params);
  if (!_common.logViewReferenceRT.is(decodedParams.logView)) {
    return decodedParams;
  }
  const matchedReference = references.find(ref => ref.name === LOG_VIEW_REFERENCE_NAME);
  if (!matchedReference) {
    throw new Error(`Could not find reference for ${LOG_VIEW_REFERENCE_NAME}`);
  }
  return {
    ...decodedParams,
    logView: {
      ...decodedParams.logView,
      logViewId: matchedReference.id
    }
  };
};
exports.injectReferences = injectReferences;