"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRequest = exports.ADDITIONAL_CONTEXT_BLOCKED_LIST_REGEX = exports.ADDITIONAL_CONTEXT_BLOCKED_LIST = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _serialized_query = require("../../../../utils/serialized_query");
var _create_metric_aggregations = require("./create_metric_aggregations");
var _create_bucket_selector = require("./create_bucket_selector");
var _utils = require("../../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This function escapes Regex special characters with a (\) so they will behave like normal text.
 * @param str input text
 * @returns input text with regex operators escaped
 * @example
 *   escapeRegex("foo.bar") -> "foo\.bar"
 *   escapeRegex("a+b?")    -> "a\+b\?"
 */
function escapeRegex(str) {
  return str.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
function wildcardToRegex(str) {
  return escapeRegex(str).replace(/\\\*/g, '.*');
}
const ADDITIONAL_CONTEXT_ALLOW_LIST = ['host.*', 'labels.*', 'tags', 'cloud.*', 'orchestrator.*'];
const ADDITIONAL_CONTEXT_BLOCKED_LIST = exports.ADDITIONAL_CONTEXT_BLOCKED_LIST = ['host.cpu.*', 'host.disk.*', 'host.network.*'];
const ADDITIONAL_CONTEXT_BLOCKED_LIST_REGEX = exports.ADDITIONAL_CONTEXT_BLOCKED_LIST_REGEX = new RegExp(`^(${ADDITIONAL_CONTEXT_BLOCKED_LIST.map(wildcardToRegex).join('|')})$`);
const createRequest = async (index, nodeType, metric, timerange, compositeSize, afterKey, condition, filterQuery, customMetric, fieldsExisted, schema) => {
  var _inventoryModels$node, _inventoryModels$node2;
  const inventoryModels = (0, _common.findInventoryModel)(nodeType);
  const composite = {
    size: compositeSize,
    sources: [{
      node: {
        terms: {
          field: inventoryModels.fields.id
        }
      }
    }],
    ...(afterKey ? {
      after: afterKey
    } : {})
  };
  const metricAggregations = await (0, _create_metric_aggregations.createMetricAggregations)(timerange, nodeType, metric, customMetric, schema);
  const bucketSelector = (0, _create_bucket_selector.createBucketSelector)(metric, condition, customMetric);
  const containerContextAgg = nodeType === 'pod' && fieldsExisted && fieldsExisted[_utils.termsAggField[_utils.KUBERNETES_POD_UID]] ? {
    containerContext: {
      terms: {
        field: _utils.termsAggField[_utils.KUBERNETES_POD_UID],
        size: _utils.NUMBER_OF_DOCUMENTS
      },
      aggs: {
        container: {
          top_hits: {
            size: 1,
            _source: {
              includes: ['container.*']
            }
          }
        }
      }
    }
  } : undefined;
  const allowList = !containerContextAgg ? ADDITIONAL_CONTEXT_ALLOW_LIST.concat('container.*') : ADDITIONAL_CONTEXT_ALLOW_LIST;
  const additionalContextAgg = {
    additionalContext: {
      top_hits: {
        size: 1,
        _source: schema === 'semconv' ? false : {
          includes: allowList,
          excludes: ADDITIONAL_CONTEXT_BLOCKED_LIST
        },
        // otel docs don't support _source to select fields, so we use docvalue_fields
        docvalue_fields: schema === 'semconv' ? allowList : []
      }
    }
  };
  const parsedFilters = (0, _serialized_query.parseFilterQuery)(filterQuery);
  const request = {
    allow_no_indices: true,
    ignore_unavailable: true,
    index,
    size: 0,
    query: {
      bool: {
        filter: [...(parsedFilters ? Array.isArray(parsedFilters) ? parsedFilters : [parsedFilters] : []), ...(0, _server.rangeQuery)(timerange.from, timerange.to), ...(schema ? (_inventoryModels$node = (_inventoryModels$node2 = inventoryModels.nodeFilter) === null || _inventoryModels$node2 === void 0 ? void 0 : _inventoryModels$node2.call(inventoryModels, {
          schema
        })) !== null && _inventoryModels$node !== void 0 ? _inventoryModels$node : [] : [])]
      }
    },
    aggs: {
      nodes: {
        composite,
        aggs: {
          ...metricAggregations,
          ...bucketSelector,
          ...additionalContextAgg,
          ...containerContextAgg
        }
      }
    }
  };
  return request;
};
exports.createRequest = createRequest;