"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFocusTrapProps = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates focusTrapProps for EuiFlyout components to restore focus to a trigger element.
 * Useful when opening a flyout from a context menu.
 */
const createFocusTrapProps = triggerElement => {
  return {
    returnFocus: () => {
      if (triggerElement) {
        var _triggerElement$focus;
        (_triggerElement$focus = triggerElement.focus) === null || _triggerElement$focus === void 0 ? void 0 : _triggerElement$focus.call(triggerElement);
        return false; // Manual focus handled
      }
      return true; // Let EUI handle focus automatically
    }
  };
};
exports.createFocusTrapProps = createFocusTrapProps;