"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateFakeEntries = generateFakeEntries;
var _faker = require("@faker-js/faker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateFakeEntries(count, startTimestamp, endTimestamp, columns) {
  const entries = [];
  const timestampStep = Math.floor((endTimestamp - startTimestamp) / count);
  for (let i = 0; i < count; i++) {
    const timestamp = i === count - 1 ? endTimestamp : startTimestamp + timestampStep * i;
    const date = new Date(timestamp).toISOString();
    entries.push({
      id: `entry-${i}`,
      index: 'logs-fake',
      context: {},
      cursor: {
        time: date,
        tiebreaker: i
      },
      columns: columns.map(column => {
        if ('timestampColumn' in column) {
          return {
            columnId: column.timestampColumn.id,
            time: date
          };
        } else if ('messageColumn' in column) {
          return {
            columnId: column.messageColumn.id,
            message: [{
              field: 'message',
              value: [fakeColumnValue('message')],
              highlights: []
            }]
          };
        } else {
          return {
            columnId: column.fieldColumn.id,
            field: column.fieldColumn.field,
            value: [fakeColumnValue(column.fieldColumn.field)],
            highlights: []
          };
        }
      })
    });
  }
  return entries;
}
function fakeColumnValue(field) {
  switch (field) {
    case 'message':
      return _faker.faker.helpers.fake('{{internet.ip}} - [{{date.past}}] "GET {{internet.url}} HTTP/1.1" 200 {{number.int}} "-" "{{internet.userAgent}}"');
    case 'event.dataset':
      return _faker.faker.helpers.fake('{{hacker.noun}}.{{hacker.noun}}');
    case 'log.file.path':
      return _faker.faker.system.filePath();
    case 'log.level':
      return _faker.faker.helpers.arrayElement(['debug', 'info', 'warn', 'error']);
    case 'host.name':
      return _faker.faker.hacker.noun();
    default:
      return _faker.faker.lorem.sentence();
  }
}