"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToLogs = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/logs-shared-plugin/common");
var _query_params = require("./query_params");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RedirectToLogs = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(share.url);
  const filter = (0, _query_params.getFilterFromLocation)(location);
  const time = (0, _query_params.getTimeFromLocation)(location);
  (0, _react.useEffect)(() => {
    logsLocator.navigate({
      query: {
        language: 'kuery',
        query: filter
      },
      timeRange: (0, _common.getTimeRange)(time)
    }, {
      replace: true
    });
  }, [filter, logsLocator, time]);
  return null;
};
exports.RedirectToLogs = RedirectToLogs;