"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataStateProvider = void 0;
exports.useMetadataProvider = useMetadataProvider;
exports.useMetadataStateContext = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _metrics_source = require("../../../containers/metrics_source");
var _use_metadata = require("./use_metadata");
var _use_date_picker = require("./use_date_picker");
var _use_asset_details_url_state = require("./use_asset_details_url_state");
var _use_request_observable = require("./use_request_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMetadataProvider({
  entityId: entityId,
  entityType: entityType
}) {
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const [, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    getDateRangeInTimestamp
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    sourceId
  } = (0, _metrics_source.useSourceContext)();
  const timeRange = (0, _react.useMemo)(() => getDateRangeInTimestamp(), [getDateRangeInTimestamp]);
  const {
    loading,
    error,
    metadata,
    reload
  } = (0, _use_metadata.useMetadata)({
    entityId,
    entityType,
    sourceId,
    timeRange,
    request$
  });
  (0, _react.useEffect)(() => {
    if (metadata !== null && metadata !== void 0 && metadata.name) {
      setUrlState({
        name: metadata.name
      });
    }
  }, [metadata === null || metadata === void 0 ? void 0 : metadata.name, setUrlState]);
  return {
    loading,
    error,
    metadata,
    refresh: reload
  };
}
const [MetadataStateProvider, useMetadataStateContext] = (0, _constate.default)(useMetadataProvider);
exports.useMetadataStateContext = useMetadataStateContext;
exports.MetadataStateProvider = MetadataStateProvider;