"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContainerKpiCharts = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kpi = require("./kpi");
var _use_container_metrics_charts = require("../../hooks/use_container_metrics_charts");
var _use_integration_check = require("../../hooks/use_integration_check");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/components/kpis/container_kpi_charts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ContainerKpiCharts = ({
  dateRange,
  dataView,
  filters,
  query,
  lastReloadRequestTime,
  loading = false
}) => {
  const isDockerContainer = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.docker
  });
  const isKubernetesContainer = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.kubernetesContainer
  });
  if (!isDockerContainer && !isKubernetesContainer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDockerContainer && /*#__PURE__*/_react.default.createElement(DockerKpiCharts, {
    dateRange: dateRange,
    dataView: dataView,
    filters: filters,
    query: query,
    lastReloadRequestTime: lastReloadRequestTime,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }), !isDockerContainer && isKubernetesContainer && /*#__PURE__*/_react.default.createElement(KubernetesKpiCharts, {
    dateRange: dateRange,
    dataView: dataView,
    filters: filters,
    query: query,
    lastReloadRequestTime: lastReloadRequestTime,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }));
};
exports.ContainerKpiCharts = ContainerKpiCharts;
const DockerKpiCharts = ({
  dateRange,
  dataView,
  filters,
  query,
  lastReloadRequestTime,
  loading = false
}) => {
  const charts = (0, _use_container_metrics_charts.useDockerContainerKpiCharts)({
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, charts.map((chartProps, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_kpi.Kpi, (0, _extends2.default)({}, chartProps, {
    dateRange: dateRange,
    filters: filters,
    query: query,
    lastReloadRequestTime: lastReloadRequestTime,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  })))));
};
const KubernetesKpiCharts = ({
  dateRange,
  dataView,
  filters,
  options,
  query,
  lastReloadRequestTime,
  loading = false
}) => {
  const charts = (0, _use_container_metrics_charts.useK8sContainerKpiCharts)({
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, charts.map((chartProps, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_kpi.Kpi, (0, _extends2.default)({}, chartProps, {
    dateRange: dateRange,
    filters: filters,
    query: query,
    lastReloadRequestTime: lastReloadRequestTime,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  })))));
};