"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortRT = exports.paginationRT = exports.paginationCursorRT = exports.getSeverityCategoryForScore = exports.getFriendlyNameForPartitionId = exports.formatOneDecimalPlace = exports.compareDatasetsByMaximumAnomalyScore = exports.ML_SEVERITY_SCORES = exports.ML_SEVERITY_COLORS = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_SEVERITY_SCORES = exports.ML_SEVERITY_SCORES = {
  warning: 3,
  minor: 25,
  major: 50,
  critical: 75
};
const ML_SEVERITY_COLORS = exports.ML_SEVERITY_COLORS = {
  critical: 'rgb(228, 72, 72)',
  major: 'rgb(229, 113, 0)',
  minor: 'rgb(255, 221, 0)',
  warning: 'rgb(125, 180, 226)'
};
const getSeverityCategoryForScore = score => {
  if (score >= ML_SEVERITY_SCORES.critical) {
    return 'critical';
  } else if (score >= ML_SEVERITY_SCORES.major) {
    return 'major';
  } else if (score >= ML_SEVERITY_SCORES.minor) {
    return 'minor';
  } else if (score >= ML_SEVERITY_SCORES.warning) {
    return 'warning';
  } else {
    // Category is too low to include
    return undefined;
  }
};
exports.getSeverityCategoryForScore = getSeverityCategoryForScore;
const formatOneDecimalPlace = number => {
  return Math.round(number * 10) / 10;
};
exports.formatOneDecimalPlace = formatOneDecimalPlace;
const getFriendlyNameForPartitionId = partitionId => {
  return partitionId !== '' ? partitionId : 'unknown';
};
exports.getFriendlyNameForPartitionId = getFriendlyNameForPartitionId;
const compareDatasetsByMaximumAnomalyScore = (firstDataset, secondDataset) => firstDataset.maximumAnomalyScore - secondDataset.maximumAnomalyScore;

// Generic Sort
exports.compareDatasetsByMaximumAnomalyScore = compareDatasetsByMaximumAnomalyScore;
const sortDirectionsRT = rt.keyof({
  asc: null,
  desc: null
});
const sortRT = fields => rt.type({
  field: fields,
  direction: sortDirectionsRT
});

// Pagination
// [Sort field value, tiebreaker value]
exports.sortRT = sortRT;
const paginationCursorRT = exports.paginationCursorRT = rt.tuple([rt.union([rt.string, rt.number]), rt.union([rt.string, rt.number])]);
const paginationPreviousPageCursorRT = rt.type({
  searchBefore: paginationCursorRT
});
const paginationNextPageCursorRT = rt.type({
  searchAfter: paginationCursorRT
});
const paginationRT = exports.paginationRT = rt.intersection([rt.type({
  pageSize: rt.number
}), rt.partial({
  cursor: rt.union([paginationPreviousPageCursorRT, paginationNextPageCursorRT])
})]);