"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withInferenceContext = void 0;
var _api = require("@opentelemetry/api");
var _create_inference_context = require("./create_inference_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates an active "inference"-scoped context. Every span created in this
 * context will be exported via the inference exporters. This allows us to export
 * a subset of spans to external systems like Phoenix.
 */
const withInferenceContext = fn => {
  const {
    context: parentContext
  } = (0, _create_inference_context.createInferenceContext)();
  return _api.context.with(parentContext, fn);
};
exports.withInferenceContext = withInferenceContext;