"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observableIntoEventSourceStream = observableIntoEventSourceStream;
var _rxjs = require("rxjs");
var _stream = require("stream");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function observableIntoEventSourceStream(source$, logger) {
  const withSerializedErrors$ = source$.pipe((0, _rxjs.catchError)(error => {
    if ((0, _inferenceCommon.isInferenceError)(error)) {
      logger === null || logger === void 0 ? void 0 : logger.error(error);
      logger === null || logger === void 0 ? void 0 : logger.debug(() => JSON.stringify(error));
      return (0, _rxjs.of)({
        type: _inferenceCommon.InferenceTaskEventType.error,
        error: {
          code: error.code,
          message: error.message,
          meta: error.meta
        }
      });
    }
    return (0, _rxjs.of)({
      type: _inferenceCommon.InferenceTaskEventType.error,
      error: {
        code: _inferenceCommon.InferenceTaskErrorCode.internalError,
        message: error.message
      }
    });
  }), (0, _rxjs.map)(event => {
    return `data: ${JSON.stringify(event)}\n\n`;
  }));
  const stream = new _stream.PassThrough();
  withSerializedErrors$.subscribe({
    next: line => {
      stream.write(line);
    },
    complete: () => {
      stream.end();
    },
    error: error => {
      stream.write(`data: ${JSON.stringify({
        type: _inferenceCommon.InferenceTaskEventType.error,
        error: {
          code: _inferenceCommon.InferenceTaskErrorCode.internalError,
          message: error.message
        }
      })}\n\n`);
      stream.end();
    }
  });
  return stream;
}