"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUpdateRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _lib = require("../../../../common/lib");
var _ = require("..");
var _schema_validation = require("./schema_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramsSchema = _configSchema.schema.object({
  name: _configSchema.schema.string()
});
const registerUpdateRoute = ({
  router,
  lib: {
    handleEsError
  }
}) => {
  router.put({
    path: (0, _.addBasePath)('/component_templates/{name}'),
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es client for authorization'
      }
    },
    validate: {
      body: _schema_validation.componentTemplateSchema,
      params: paramsSchema
    }
  }, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const {
      name
    } = request.params;
    try {
      var _existingComponentTem, _existingComponentTem2, _existingComponentTem3, _existingComponentTem4, _existingComponentTem5;
      // Verify component exists; ES will throw 404 if not
      const existingComponentTemplate = await client.asCurrentUser.transport.request({
        method: 'GET',
        path: `/_component_template/${name}`
      });
      // TODO: Replace with the following when the client includes data_stream_options in ClusterComponentTemplateSummary
      // https://github.com/elastic/kibana/issues/220614
      // const existingComponentTemplate = await client.asCurrentUser.cluster.getComponentTemplate({
      //   name,
      // });
      const existingDataStreamOptions = (_existingComponentTem = existingComponentTemplate === null || existingComponentTemplate === void 0 ? void 0 : (_existingComponentTem2 = existingComponentTemplate.component_templates) === null || _existingComponentTem2 === void 0 ? void 0 : (_existingComponentTem3 = _existingComponentTem2[0]) === null || _existingComponentTem3 === void 0 ? void 0 : (_existingComponentTem4 = _existingComponentTem3.component_template) === null || _existingComponentTem4 === void 0 ? void 0 : (_existingComponentTem5 = _existingComponentTem4.template) === null || _existingComponentTem5 === void 0 ? void 0 : _existingComponentTem5.data_stream_options) !== null && _existingComponentTem !== void 0 ? _existingComponentTem : undefined;
      const serializedComponentTemplate = (0, _lib.serializeComponentTemplate)(request.body, existingDataStreamOptions);
      const responseBody = await client.asCurrentUser.cluster.putComponentTemplate({
        name,
        ...serializedComponentTemplate,
        template: serializedComponentTemplate.template
      });
      return response.ok({
        body: responseBody
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
};
exports.registerUpdateRoute = registerUpdateRoute;