"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openIndicesStart = exports.openIndices = void 0;
var _reduxActions = require("redux-actions");
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _ = require(".");
var _notification = require("../../services/notification");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openIndicesStart = exports.openIndicesStart = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_OPEN_INDICES_START');
const openIndices = ({
  indexNames
}) => async dispatch => {
  dispatch(openIndicesStart({
    indexNames
  }));
  try {
    await (0, _services.openIndices)(indexNames);
  } catch (error) {
    _notification.notificationService.showDangerToast(error.body.message);
    return dispatch((0, _.clearRowStatus)({
      indexNames
    }));
  }
  dispatch((0, _.reloadIndices)(indexNames));
  _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.openIndicesAction.successfullyOpenedIndicesMessage', {
    defaultMessage: 'Successfully opened {count, plural, one {# index} other {# indices} }',
    values: {
      count: indexNames.length
    }
  }));
};
exports.openIndices = openIndices;