"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageMappingsContent = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _utils = require("../../../../components/mappings_editor/lib/utils");
var _use_details_page_mappings_model_management = require("../../../../../hooks/use_details_page_mappings_model_management");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components/mappings_editor/components");
var _document_fields_search = require("../../../../components/mappings_editor/components/document_fields/document_fields_search");
var _fields = require("../../../../components/mappings_editor/components/document_fields/fields");
var _search_fields = require("../../../../components/mappings_editor/components/document_fields/search_fields");
var _multiple_mappings_warning = require("../../../../components/mappings_editor/components/multiple_mappings_warning");
var _lib = require("../../../../components/mappings_editor/lib");
var _mappings_state_context = require("../../../../components/mappings_editor/mappings_state_context");
var _details_page_filter_fields = require("./details_page_filter_fields");
var _use_state_listener = require("../../../../components/mappings_editor/use_state_listener");
var _api = require("../../../../services/api");
var _notification = require("../../../../services/notification");
var _semantic_text_banner = require("./semantic_text_banner");
var _trained_models_deployment_modal = require("./trained_models_deployment_modal");
var _parse_mappings = require("../../../../shared/parse_mappings");
var _details_page_empty_mappings = require("./details_page_empty_mappings");
var _add_field_button = require("./details_page_mappings_content/add_field_button");
var _mappings_information_panels = require("./details_page_mappings_content/mappings_information_panels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_mappings_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isInferencePreconfigured = inferenceId => inferenceId.startsWith('.');
const DetailsPageMappingsContent = ({
  index,
  data,
  jsonData,
  refetchMapping,
  showAboutMappings,
  hasUpdateMappingsPrivilege
}) => {
  var _capabilities$ml;
  const {
    core: {
      application: {
        capabilities,
        navigateToUrl
      },
      http
    },
    plugins: {
      ml,
      licensing
    },
    config,
    overlays,
    history
  } = (0, _app_context.useAppContext)();
  const pendingFieldsRef = (0, _react2.useRef)(null);
  const state = (0, _mappings_state_context.useMappingsState)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    fetchInferenceToModelIdMap
  } = (0, _use_details_page_mappings_model_management.useDetailsPageMappingsModelManagement)();
  const [isPlatinumLicense, setIsPlatinumLicense] = (0, _react2.useState)(false);
  const [errorsInTrainedModelDeployment, setErrorsInTrainedModelDeployment] = (0, _react2.useState)({});
  const [hasSavedFields, setHasSavedFields] = (0, _react2.useState)(false);
  const [isAddingFields, setAddingFields] = (0, _react2.useState)(false);
  const [previousState, setPreviousState] = (0, _react2.useState)(state);
  const [saveMappingError, setSaveMappingError] = (0, _react2.useState)(undefined);
  const [isJSONVisible, setIsJSONVisible] = (0, _react2.useState)(false);
  const [isUpdatingMappings, setIsUpdatingMappings] = (0, _react2.useState)(false);
  const {
    enableSemanticText: isSemanticTextEnabled
  } = config;
  const hasMLPermissions = capabilities !== null && capabilities !== void 0 && (_capabilities$ml = capabilities.ml) !== null && _capabilities$ml !== void 0 && _capabilities$ml.canGetTrainedModels ? true : false;
  const semanticTextInfo = {
    isSemanticTextEnabled: isSemanticTextEnabled && hasMLPermissions && isPlatinumLicense,
    indexName: index.name,
    ml,
    setErrorsInTrainedModelDeployment
  };
  const hasMappings = state.mappingViewFields.rootLevelFields.length > 0;
  const indexName = index.name;
  const pendingFieldListId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'pendingFieldListId'
  });
  const hasSemanticText = (0, _utils.hasSemanticTextField)(state.fields);
  const searchTerm = isAddingFields ? previousState.search.term.trim() : state.search.term.trim();
  const newFieldsLength = (0, _react2.useMemo)(() => {
    return Object.keys(state.fields.byId).length;
  }, [state.fields.byId]);
  const previousStateSelectedDataTypes = (0, _react2.useMemo)(() => {
    return previousState.filter.selectedOptions.filter(option => option.checked === 'on').map(option => option.label);
  }, [previousState.filter.selectedOptions]);
  const {
    parsedDefaultValue,
    multipleMappingsDeclared
  } = (0, _react2.useMemo)(() => (0, _parse_mappings.parseMappings)(jsonData), [jsonData]);
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    titleText: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.unsavedChangesPromptTitle', {
      defaultMessage: 'Exit without saving changes?'
    }),
    messageText: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.unsavedChangesPromptMessage', {
      defaultMessage: 'Your changes will be lost if you leave this page without saving the mapping.'
    }),
    hasUnsavedChanges: isAddingFields,
    openConfirm: overlays.openConfirm,
    history,
    http,
    navigateToUrl
  });
  (0, _use_state_listener.useMappingsStateListener)({
    value: parsedDefaultValue,
    status: 'disabled'
  });
  const onToggleChange = () => {
    setIsJSONVisible(!isJSONVisible);
  };
  const onCancelAddingNewFields = (0, _react2.useCallback)(() => {
    setAddingFields(!isAddingFields);

    //  reset mappings to previous state
    dispatch({
      type: 'editor.replaceMappings',
      value: {
        ...previousState,
        documentFields: {
          status: 'disabled',
          editor: 'default'
        }
      }
    });
  }, [isAddingFields, dispatch, previousState]);
  const addFieldButtonOnClick = (0, _react2.useCallback)(() => {
    setAddingFields(!isAddingFields);

    // when adding new field, save previous state. This state is then used by FieldsList component to show only saved mappings.
    setPreviousState(state);

    // reset mappings and change status to create field.
    dispatch({
      type: 'editor.replaceMappings',
      value: {
        ...state,
        fields: {
          ...state.fields,
          byId: {},
          rootLevelFields: []
        },
        filter: {
          filteredFields: [],
          selectedOptions: [],
          selectedDataTypes: []
        },
        documentFields: {
          status: 'creatingField',
          editor: 'default'
        }
      }
    });
  }, [dispatch, isAddingFields, state]);
  const updateMappings = (0, _react2.useCallback)(async forceSaveMappings => {
    let inferenceToModelIdMap = state.inferenceToModelIdMap;
    setIsUpdatingMappings(true);
    try {
      var _ml$mlApi;
      await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : _ml$mlApi.savedObjects.syncSavedObjects());
      if (isSemanticTextEnabled && hasMLPermissions && hasSemanticText && !forceSaveMappings) {
        inferenceToModelIdMap = await fetchInferenceToModelIdMap();
      }
      const fields = hasSemanticText ? (0, _utils.getStateWithCopyToFields)(state).fields : state.fields;
      const denormalizedFields = (0, _lib.deNormalize)(fields);
      const inferenceIdsInPendingList = forceSaveMappings ? [] : Object.values(denormalizedFields).filter(_utils.isSemanticTextField).map(field => field.inference_id).filter(inferenceId => {
        var _inferenceToModelIdMa, _inferenceToModelIdMa2;
        return inferenceId && ((_inferenceToModelIdMa = inferenceToModelIdMap) === null || _inferenceToModelIdMa === void 0 ? void 0 : _inferenceToModelIdMa[inferenceId].trainedModelId) &&
        // third-party inference models don't have trainedModelId
        !((_inferenceToModelIdMa2 = inferenceToModelIdMap) !== null && _inferenceToModelIdMa2 !== void 0 && _inferenceToModelIdMa2[inferenceId].isDeployed) && !isInferencePreconfigured(inferenceId);
      });
      setHasSavedFields(true);
      if (inferenceIdsInPendingList.length === 0) {
        const {
          error
        } = await (0, _api.updateIndexMappings)(indexName, denormalizedFields);
        if (!error) {
          _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.successfullyUpdatedIndexMappings', {
            defaultMessage: 'Updated index mapping'
          }));
          refetchMapping();
          setHasSavedFields(false);
        } else {
          setSaveMappingError(error.message);
        }
      }
    } catch (exception) {
      setSaveMappingError(exception.message);
    }
    setIsUpdatingMappings(false);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [state.fields]);
  const onSearchChange = (0, _react2.useCallback)(value => {
    if (isAddingFields) {
      setPreviousState({
        ...previousState,
        search: {
          term: value,
          result: (0, _lib.searchFields)(value, previousStateSelectedDataTypes.length > 0 ? (0, _lib.getFieldsMatchingFilterFromState)(previousState, previousStateSelectedDataTypes) : previousState.fields.byId)
        }
      });
    } else {
      dispatch({
        type: 'search:update',
        value
      });
    }
  }, [dispatch, previousState, isAddingFields, previousStateSelectedDataTypes]);
  const onClearSearch = (0, _react2.useCallback)(() => {
    setPreviousState({
      ...previousState,
      search: {
        term: '',
        result: (0, _lib.searchFields)('', previousState.filter.selectedDataTypes.length > 0 ? (0, _lib.getFieldsMatchingFilterFromState)(previousState, previousState.filter.selectedDataTypes) : previousState.fields.byId)
      }
    });
  }, [previousState]);
  const jsonBlock = /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    "data-test-subj": "indexDetailsMappingsCodeBlock",
    css: (0, _react.css)`
        height: 100%;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 5
    }
  }, data);
  const searchResultComponent = isAddingFields ? /*#__PURE__*/_react2.default.createElement(_search_fields.SearchResult, {
    result: previousState.search.result,
    documentFieldsState: previousState.documentFields,
    onClearSearch: onClearSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react2.default.createElement(_search_fields.SearchResult, {
    result: state.search.result,
    documentFieldsState: state.documentFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 5
    }
  });
  const fieldsListComponent = isAddingFields ? /*#__PURE__*/_react2.default.createElement(_fields.FieldsList, {
    fields: previousStateSelectedDataTypes.length > 0 ? previousState.filter.filteredFields : (0, _lib.getFieldsFromState)(previousState.fields),
    state: previousState,
    setPreviousState: setPreviousState,
    isAddingFields: isAddingFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react2.default.createElement(_fields.FieldsList, {
    fields: state.filter.selectedDataTypes.length > 0 ? state.filter.filteredFields : (0, _lib.getFieldsFromState)(state.fields),
    state: state,
    isAddingFields: isAddingFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 5
    }
  });
  const treeViewBlock = /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, multipleMappingsDeclared ? /*#__PURE__*/_react2.default.createElement(_multiple_mappings_warning.MultipleMappingsWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 9
    }
  }) : searchTerm !== '' ? searchResultComponent : fieldsListComponent);
  const errorSavingMappings = saveMappingError && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    "data-test-subj": "indexDetailsSaveMappingsError",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.error.title', {
      defaultMessage: 'Error saving mapping'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.error.description",
    defaultMessage: "Error saving mapping: {errorMessage}",
    values: {
      errorMessage: saveMappingError
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 7
    }
  }));
  const mappingsWrapperStyles = (0, _react.css)`
    height: 100%;
    ${(0, _eui.useEuiBreakpoint)(['xl'])} {
      flex-wrap: nowrap;
    }
  `;
  const saveMappingsButton = /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    onClick: () => updateMappings(),
    color: "success",
    fill: true,
    disabled: newFieldsLength === 0,
    "data-test-subj": "indexDetailsMappingsSaveMappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.saveMappings",
    defaultMessage: "Save mapping",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 7
    }
  }));
  (0, _react2.useEffect)(() => {
    const subscription = licensing === null || licensing === void 0 ? void 0 : licensing.license$.subscribe(license => {
      setIsPlatinumLicense(license.isActive && license.hasAtLeast('platinum'));
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [licensing]);
  (0, _react2.useEffect)(() => {
    if (!isSemanticTextEnabled || !hasMLPermissions) {
      return;
    }
    const fetchData = async () => {
      await fetchInferenceToModelIdMap();
    };
    fetchData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isSemanticTextEnabled, hasMLPermissions]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    direction: "rowReverse",
    css: mappingsWrapperStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 7
    }
  }, showAboutMappings && hasMappings && /*#__PURE__*/_react2.default.createElement(_mappings_information_panels.MappingsInformationPanels, {
    indexName: indexName,
    refetchMapping: refetchMapping,
    hasUpdateMappingsPrivilege: hasUpdateMappingsPrivilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 9
    }
  }, hasMLPermissions && !hasSemanticText && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_semantic_text_banner.SemanticTextBanner, {
    isSemanticTextEnabled: isSemanticTextEnabled,
    isPlatinumLicense: isPlatinumLicense,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 15
    }
  })), !hasMappings && (!isAddingFields ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_details_page_empty_mappings.EmptyMappingsContent, {
    addFieldButton: /*#__PURE__*/_react2.default.createElement(_add_field_button.AddFieldButton, {
      hasUpdateMappingsPrivilege: hasUpdateMappingsPrivilege,
      addFieldButtonOnClick: addFieldButtonOnClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 17
    }
  }, saveMappingsButton))), hasMappings && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_details_page_filter_fields.MappingsFilter, {
    isAddingFields: isAddingFields,
    isJSONVisible: isJSONVisible,
    previousState: previousState,
    setPreviousState: setPreviousState,
    state: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_document_fields_search.DocumentFieldsSearch, {
    searchValue: isAddingFields ? previousState.search.term : state.search.term,
    onSearchChange: onSearchChange,
    disabled: isJSONVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 17
    }
  })), !index.hidden && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 17
    }
  }, !isAddingFields ? /*#__PURE__*/_react2.default.createElement(_add_field_button.AddFieldButton, {
    color: 'text',
    hasUpdateMappingsPrivilege: hasUpdateMappingsPrivilege,
    addFieldButtonOnClick: addFieldButtonOnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 21
    }
  }) : saveMappingsButton), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 478,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": "indexDetailsMappingsToggleViewButton",
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.mappingsViewButtonGroupAriaLabel', {
      defaultMessage: 'Mappings View Button Group'
    }),
    onClick: onToggleChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 479,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: !isJSONVisible,
    hasActiveFilters: !isJSONVisible,
    withNext: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 489,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.tableView",
    defaultMessage: "List",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: isJSONVisible,
    hasActiveFilters: isJSONVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 500,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.json",
    defaultMessage: "JSON",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 505,
      columnNumber: 21
    }
  }))))), errorSavingMappings, isAddingFields && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    ref: pendingFieldsRef,
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 516,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 517,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: pendingFieldListId,
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      paddingSize: "s",
      hasShadow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 522,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "baseline",
      "data-test-subj": "indexDetailsMappingsPendingBlock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 523,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: 6,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 528,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 529,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.addMappingPendingBlock",
      defaultMessage: "Pending fields",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 530,
        columnNumber: 29
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 536,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiNotificationBadge, {
      color: newFieldsLength > 0 ? 'accent' : 'subdued',
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 537,
        columnNumber: 27
      }
    }, newFieldsLength)))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_components.DocumentFields, {
    onCancelAddingNewFields: newFieldsLength <= 0 ? onCancelAddingNewFields : undefined,
    isAddingFields: isAddingFields,
    semanticTextInfo: semanticTextInfo,
    pendingFieldsRef: pendingFieldsRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 549,
      columnNumber: 21
    }
  }))))), hasMappings && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
                min-width: 600px;
                height: 100%;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 563,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 570,
      columnNumber: 15
    }
  }, isJSONVisible ? jsonBlock : treeViewBlock)))), isSemanticTextEnabled && isAddingFields && hasSavedFields && /*#__PURE__*/_react2.default.createElement(_trained_models_deployment_modal.TrainedModelsDeploymentModal, {
    errorsInTrainedModelDeployment: errorsInTrainedModelDeployment,
    forceSaveMappings: () => updateMappings(true),
    saveMappings: () => updateMappings(),
    saveMappingsLoading: isUpdatingMappings,
    setErrorsInTrainedModelDeployment: setErrorsInTrainedModelDeployment,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 578,
      columnNumber: 9
    }
  }));
};
exports.DetailsPageMappingsContent = DetailsPageMappingsContent;