"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsPromotion = StreamsPromotion;
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/data_stream_list/data_stream_detail_panel/streams_promotion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamsPromotion({
  dataStreamName
}) {
  var _useObservable;
  const {
    url,
    plugins: {
      streams
    }
  } = (0, _app_context.useAppContext)();
  const streamsEnabled = ((_useObservable = (0, _useObservable2.default)((streams === null || streams === void 0 ? void 0 : streams.navigationStatus$) || _rxjs.EMPTY)) === null || _useObservable === void 0 ? void 0 : _useObservable.status) === 'enabled';
  const streamsLocator = url.locators.get(_deeplinksObservability.STREAMS_APP_LOCATOR_ID);
  if (!streamsEnabled || !streamsLocator) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.idxMgmt.streamsPromotion.title', {
      defaultMessage: 'Explore the New Streams UI'
    }),
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.streamsPromotion.description', {
    defaultMessage: 'A better way to manage your data streams is here! The new Streams UI provides a streamlined experience with improved insights and management tools.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => streamsLocator.navigate({
      name: dataStreamName
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.streamsPromotion.button', {
    defaultMessage: 'Go to Streams'
  })))));
}