"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexManagementDependencies = getIndexManagementDependencies;
exports.mountManagementSection = mountManagementSection;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _plugin = require("../../common/constants/plugin");
var _breadcrumbs = require("./services/breadcrumbs");
var _documentation = require("./services/documentation");
var _services = require("./services");
var _ = require(".");
var _api = require("./services/api");
var _notification = require("./services/notification");
var _http = require("./services/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initSetup({
  usageCollection,
  reindexService,
  core
}) {
  const {
    http,
    notifications
  } = core;
  _http.httpService.setup(http);
  _notification.notificationService.setup(notifications);
  const uiMetricService = new _services.UiMetricService(_constants.UIM_APP_NAME);
  (0, _api.setUiMetricService)(uiMetricService);
  uiMetricService.setup(usageCollection);
  (0, _api.setReindexService)(reindexService);
  return {
    uiMetricService
  };
}
function getIndexManagementDependencies({
  core,
  usageCollection,
  extensionsService,
  history,
  isFleetEnabled,
  kibanaVersion,
  config,
  cloud,
  startDependencies,
  uiMetricService,
  canUseSyntheticSource,
  canUseEis,
  reindexService
}) {
  const {
    docLinks,
    application,
    uiSettings,
    settings
  } = core;
  const {
    url
  } = startDependencies.share;
  const {
    monitor,
    manageEnrich,
    monitorEnrich,
    manageIndexTemplates
  } = application.capabilities.index_management;
  return {
    core: {
      getUrlForApp: application.getUrlForApp,
      ...core
    },
    plugins: {
      usageCollection,
      isFleetEnabled,
      share: startDependencies.share,
      cloud,
      console: startDependencies.console,
      ml: startDependencies.ml,
      streams: startDependencies.streams,
      licensing: startDependencies.licensing,
      reindexService
    },
    services: {
      httpService: _http.httpService,
      notificationService: _notification.notificationService,
      uiMetricService,
      extensionsService
    },
    config,
    history,
    setBreadcrumbs: _breadcrumbs.breadcrumbService.setBreadcrumbs,
    uiSettings,
    settings,
    url,
    docLinks,
    kibanaVersion,
    overlays: core.overlays,
    canUseSyntheticSource,
    canUseEis,
    privs: {
      monitor: !!monitor,
      manageEnrich: !!manageEnrich,
      monitorEnrich: !!monitorEnrich,
      manageIndexTemplates: !!manageIndexTemplates
    }
  };
}
async function mountManagementSection({
  coreSetup,
  usageCollection,
  params,
  extensionsService,
  isFleetEnabled,
  kibanaVersion,
  config,
  cloud,
  canUseSyntheticSource,
  canUseEis,
  reindexService
}) {
  const {
    element,
    setBreadcrumbs,
    history
  } = params;
  const [core, startDependencies] = await coreSetup.getStartServices();
  const {
    docLinks,
    chrome: {
      docTitle
    }
  } = core;
  docTitle.change(_plugin.PLUGIN.getI18nName(_i18n.i18n));
  _breadcrumbs.breadcrumbService.setup(setBreadcrumbs);
  _documentation.documentationService.setup(docLinks);
  const {
    uiMetricService
  } = initSetup({
    usageCollection,
    core,
    reindexService: reindexService === null || reindexService === void 0 ? void 0 : reindexService.reindexService
  });
  const appDependencies = getIndexManagementDependencies({
    cloud,
    config,
    core,
    extensionsService,
    history,
    isFleetEnabled,
    kibanaVersion,
    startDependencies,
    uiMetricService,
    usageCollection,
    canUseSyntheticSource,
    canUseEis,
    reindexService
  });
  const unmountAppCallback = (0, _.renderApp)(element, {
    core,
    dependencies: appDependencies
  });
  return () => {
    docTitle.reset();
    unmountAppCallback();
  };
}