"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreeItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _tree = require("./tree");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/tree/tree_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    esUiTreeItem: (0, _react2.css)`
      list-style-type: none;
      border-left: ${euiTheme.border.thin};
      margin-left: ${euiTheme.size.l};
      padding-bottom: ${euiTheme.size.s};

      &:first-child {
        padding-top: ${euiTheme.size.s};
      }

      &:last-child {
        border-left-color: transparent;
        padding-bottom: 0;
      }
    `,
    esUiTreeItemLabel: (0, _react2.css)`
      font-size: ${(0, _eui.useEuiFontSize)('s').fontSize};
      padding-left: ${euiTheme.size.l};
      position: relative;

      &::before {
        content: '';
        position: absolute;
        top: 0;
        left: -1px;
        bottom: 50%;
        width: ${euiTheme.size.base};
        border: ${euiTheme.border.thin};
        border-top: none;
        border-right: none;
      }
    `
  };
};
const TreeItem = ({
  treeItem
}) => {
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement("li", {
    css: styles.esUiTreeItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.esUiTreeItemLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, treeItem.label), treeItem.children && /*#__PURE__*/_react.default.createElement(_tree.Tree, {
    tree: treeItem.children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 29
    }
  }));
};
exports.TreeItem = TreeItem;