"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactWindow = require("react-window");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mappings_state_context = require("../../../mappings_state_context");
var _search_result_item = require("./search_result_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/search_fields/search_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ITEM_HEIGHT = 64;
const Row = /*#__PURE__*/_react.default.memo(({
  data,
  index,
  style
}) => {
  // Data passed to List as "itemData" is available as props.data
  const {
    fieldToEdit,
    result,
    status
  } = data;
  const item = result[index];
  return /*#__PURE__*/_react.default.createElement("div", {
    key: item.field.id,
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_search_result_item.SearchResultItem, {
    item: item,
    areActionButtonsVisible: status === 'idle',
    isDimmed: status === 'editingField' && fieldToEdit !== item.field.id,
    isHighlighted: status === 'editingField' && fieldToEdit === item.field.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
}, _reactWindow.areEqual);
const SearchResult = exports.SearchResult = /*#__PURE__*/_react.default.memo(({
  result,
  documentFieldsState: {
    status,
    fieldToEdit
  },
  style: virtualListStyle,
  onClearSearch
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const listHeight = Math.min(result.length * ITEM_HEIGHT, 600);
  const clearSearch = () => {
    if (onClearSearch !== undefined) {
      onClearSearch();
    } else {
      dispatch({
        type: 'search:update',
        value: ''
      });
    }
  };
  const itemData = (0, _react.useMemo)(() => ({
    result,
    status,
    fieldToEdit
  }), [fieldToEdit, result, status]);
  return result.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "mappingsEditorSearchResultEmptyPrompt",
    iconType: "search",
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.searchResult.emptyPromptTitle",
      defaultMessage: "No fields match your search",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 13
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: clearSearch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.searchResult.emptyPrompt.clearSearchButtonLabel",
      defaultMessage: "Clear search",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_reactWindow.FixedSizeList, {
    "data-test-subj": "mappingsEditorSearchResult",
    style: {
      overflowX: 'hidden',
      ...virtualListStyle
    },
    width: "100%",
    height: listHeight,
    itemData: itemData,
    itemCount: result.length,
    itemSize: ITEM_HEIGHT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, Row);
});
SearchResult.displayName = 'SearchResult'; // display name required for tests to work with React.memo