"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentFieldsSearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/document_fields_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DocumentFieldsSearch = exports.DocumentFieldsSearch = /*#__PURE__*/_react.default.memo(({
  searchValue,
  onSearchChange,
  disabled = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    disabled: disabled,
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.documentFields.searchFieldsPlaceholder', {
      defaultMessage: 'Search fields'
    }),
    value: searchValue,
    onChange: e => {
      // Temporary fix until EUI fixes the contract
      // See my comment https://github.com/elastic/eui/pull/2723/files#r366725059
      if (typeof e === 'string') {
        onSearchChange(e);
      } else {
        onSearchChange(e.target.value);
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.documentFields.searchFieldsAriaLabel', {
      defaultMessage: 'Search mapped fields'
    }),
    "data-test-subj": "indexDetailsMappingsFieldSearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 9
    }
  }));
});