"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterListButton = FilterListButton;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_selector/components/filter_list_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react.css)`
      box-shadow: none;
      height: ${euiTheme.size.xxl}; /* Align the height with the search input height */

      &,
      & > :first-child .euiFilterButton {
        /* EUI specificity override */
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
      }

      &::after {
        border: ${euiTheme.border.thin};
      }
    `
  };
};
function FilterListButton({
  onChange,
  filters
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const styles = useStyles();
  const activeFilters = Object.values(filters).filter(v => v.checked === 'on');
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const selectableOptions = Object.entries(filters).map(([filter, item]) => ({
    key: filter,
    label: item.name,
    checked: item.checked,
    'data-test-subj': 'filterItem'
  }));
  const toggleFilter = filter => {
    const previousValue = filters[filter].checked;
    const nextValue = previousValue === 'on' ? 'off' : 'on';
    onChange({
      ...filters,
      [filter]: {
        ...filters[filter],
        checked: nextValue
      }
    });
  };
  const button = /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: Object.keys(filters).length,
    hasActiveFilters: activeFilters.length > 0,
    numActiveFilters: activeFilters.length,
    "data-test-subj": "filterButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexTemplatesList.filterButtonLabel",
    defaultMessage: "Filter",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterGroup, {
    css: styles.container,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    "data-test-subj": "filterList",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    allowExclusions: true,
    listProps: {
      onFocusBadge: false,
      style: {
        minWidth: 150
      }
    },
    options: selectableOptions,
    onChange: (newOptions, event, changedOption) => {
      if (changedOption) {
        toggleFilter(changedOption.key);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, list => list)));
}