"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesListItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared = require("../../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_selector/component_templates_list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = ({
  isSelected
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    listItem: (0, _react.css)`
      background-color: ${euiTheme.colors.body};
      padding: ${euiTheme.size.m};
      border-bottom: ${euiTheme.border.thin};
      position: relative;
      height: calc(${euiTheme.size.l} * 2);

      ${isSelected && (0, _react.css)`
        &::before {
          content: '';
          background-color: rgba(${euiTheme.colors.emptyShade}, 0.7);
          height: 100%;
          left: 0;
          position: absolute;
          top: 0;
          width: 100%;
          z-index: 1;
        }
      `}
    `,
    contentIndicator: (0, _react.css)`
      flex-direction: row;
    `,
    checkIcon: (0, _react.css)`
      position: absolute;
      right: ${euiTheme.size.base};
      top: ${euiTheme.size.base};
      z-index: 2;
    `
  };
};
const ComponentTemplatesListItem = ({
  component,
  onViewDetail,
  actions,
  isSelected = false,
  dragHandleProps
}) => {
  const hasActions = actions && actions.length > 0;
  const isSelectedValue = typeof isSelected === 'function' ? isSelected(component) : isSelected;
  const isDraggable = Boolean(dragHandleProps);
  const styles = useStyles({
    isSelected: isSelectedValue
  });
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.listItem,
    "data-test-subj": "item",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, isDraggable && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement("div", (0, _extends2.default)({}, dragHandleProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "grab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    onClick: () => onViewDetail(component),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, component.name)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.contentIndicator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_shared.TemplateContentIndicator, {
    settings: component.hasSettings,
    mappings: component.hasMappings,
    aliases: component.hasAliases,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  })))), hasActions && !isSelectedValue && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, actions.map((action, i) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: action.label,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: action.icon,
    onClick: () => action.handler(component),
    "data-test-subj": `action-${action.icon}`,
    "aria-label": action.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 21
    }
  }))))))), isSelectedValue && /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    css: styles.checkIcon,
    type: "check",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 27
    }
  }));
};
exports.ComponentTemplatesListItem = ComponentTemplatesListItem;