"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TutorialDirectory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _homeSampleDataTab = require("@kbn/home-sample-data-tab");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _constants = require("../../../common/constants");
var _synopsis = require("./synopsis");
var _kibana_services = require("../kibana_services");
var _load_tutorials = require("../load_tutorials");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/tutorial_directory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SAMPLE_DATA_TAB_ID = 'sampleData';
const integrationsTitle = _i18n.i18n.translate('home.breadcrumbs.integrationsAppTitle', {
  defaultMessage: 'Integrations'
});
class TutorialDirectoryUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", void 0);
    (0, _defineProperty2.default)(this, "tabs", void 0);
    (0, _defineProperty2.default)(this, "setBreadcrumbs", () => {
      const tab = this.getSelectedTab();
      const breadcrumbs = [{
        text: integrationsTitle,
        href: this.props.addBasePath(`/app/integrations/browse`)
      }];
      if (tab !== null && tab !== void 0 && tab.name) {
        breadcrumbs.push({
          text: tab.name,
          href: ''
        });
      }
      (0, _kibana_services.getServices)().chrome.setBreadcrumbs(breadcrumbs, {
        project: {
          value: breadcrumbs
        }
      });
    });
    (0, _defineProperty2.default)(this, "onSelectedTabChanged", id => {
      this.setState({
        selectedTabId: id
      });
      // Update URL to reflect the selected tab
      (0, _kibana_services.getServices)().history.push(`#/tutorial_directory/${id}`);
    });
    (0, _defineProperty2.default)(this, "getTabs", () => {
      return this.tabs.map(tab => ({
        label: tab.name,
        onClick: () => this.onSelectedTabChanged(tab.id),
        isSelected: tab.id === this.state.selectedTabId,
        'data-test-subj': `homeTab-${tab.id}`
      }));
    });
    (0, _defineProperty2.default)(this, "getSelectedTab", () => {
      return this.tabs.find(({
        id
      }) => id === this.state.selectedTabId);
    });
    (0, _defineProperty2.default)(this, "renderTabContent", () => {
      const tab = this.getSelectedTab();
      if (tab !== null && tab !== void 0 && tab.content) {
        return tab.content;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 4,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 7
        }
      }, this.state.tutorialCards.filter(tutorial => {
        return this.state.selectedTabId === SAMPLE_DATA_TAB_ID || this.state.selectedTabId === tutorial.category;
      }).map(tutorial => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          "data-test-subj": `homeTab-${tutorial.name}`,
          key: tutorial.name,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 239,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_synopsis.Synopsis, {
          id: tutorial.id,
          iconType: tutorial.icon,
          description: tutorial.description,
          title: tutorial.name,
          url: tutorial.url,
          onClick: tutorial.onClick,
          isBeta: tutorial.isBeta,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 240,
            columnNumber: 17
          }
        }));
      }));
    });
    (0, _defineProperty2.default)(this, "renderHeaderLinks", () => {
      const headerLinks = (0, _kibana_services.getServices)().tutorialService.getDirectoryHeaderLinks();
      return headerLinks.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 7
        }
      }, headerLinks.map((HeaderLink, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(HeaderLink, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 13
        }
      })))) : null;
    });
    const extraTabs = (0, _kibana_services.getServices)().addDataService.getAddDataTabs();
    this.tabs = [...extraTabs.map(({
      id,
      name,
      getComponent
    }) => ({
      id,
      name,
      content: getComponent()
    })), {
      id: SAMPLE_DATA_TAB_ID,
      name: this.props.intl.formatMessage({
        id: 'home.tutorial.tabs.sampleDataTitle',
        defaultMessage: 'Sample data'
      }),
      content: /*#__PURE__*/_react.default.createElement(_homeSampleDataTab.SampleDataTab, {
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 18
        }
      })
    }];
    this._isMounted = false;
    let openTab = SAMPLE_DATA_TAB_ID;
    if (props.openTab && this.tabs.some(tab => {
      return tab.id === props.openTab;
    })) {
      openTab = props.openTab;
    }
    this.state = {
      selectedTabId: openTab,
      tutorialCards: []
    };
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async componentDidMount() {
    this._isMounted = true;
    this.setBreadcrumbs();
    const tutorialConfigs = await (0, _load_tutorials.getTutorials)();
    if (!this._isMounted) {
      return;
    }
    let tutorialCards = tutorialConfigs.map(tutorialConfig => {
      // add base path to SVG based icons
      let icon = tutorialConfig.euiIconType;
      if (icon && icon.includes('/')) {
        icon = this.props.addBasePath(icon);
      }
      return {
        id: tutorialConfig.id,
        category: tutorialConfig.category,
        icon,
        name: tutorialConfig.name,
        description: tutorialConfig.shortDescription,
        url: this.props.addBasePath(`#/tutorial/${tutorialConfig.id}`),
        elasticCloud: tutorialConfig.elasticCloud,
        isBeta: tutorialConfig.isBeta
      };
    });

    // Add card for sample data that only gets show in "all" tab
    tutorialCards.push({
      id: 'sample_data',
      name: this.props.intl.formatMessage({
        id: 'home.tutorial.card.sampleDataTitle',
        defaultMessage: 'Sample Data'
      }),
      description: this.props.intl.formatMessage({
        id: 'home.tutorial.card.sampleDataDescription',
        defaultMessage: 'Get started exploring Kibana with these "one click" data sets.'
      }),
      url: this.props.addBasePath('#/tutorial_directory/sampleData'),
      category: _constants.TutorialsCategory.OTHER,
      onClick: this.onSelectedTabChanged.bind(null, SAMPLE_DATA_TAB_ID)
    });
    if (this.props.isCloudEnabled) {
      tutorialCards = tutorialCards.filter(tutorial => {
        return _lodash.default.has(tutorial, 'elasticCloud');
      });
    }
    tutorialCards.sort((a, b) => {
      return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
    });
    this.setState({
      tutorialCards
    });
  }
  componentDidUpdate(_prevProps, prevState) {
    // Update selected tab when URL changes (e.g., browser back/forward)
    if (_prevProps.openTab !== this.props.openTab) {
      const newTab = this.props.openTab;
      // Validate that the tab exists
      const tabExists = this.tabs.some(tab => tab.id === newTab);
      if (!tabExists) {
        // If the tab does not exist, redirect to the default tab
        (0, _kibana_services.getServices)().history.push(`#/tutorial_directory/${SAMPLE_DATA_TAB_ID}`);
      } else if (newTab !== this.state.selectedTabId) {
        this.setState({
          selectedTabId: newTab
        });
      }
    }
    if (prevState.selectedTabId !== this.state.selectedTabId) {
      this.setBreadcrumbs();
    }
  }
  render() {
    const headerLinks = this.renderHeaderLinks();
    const tabs = this.getTabs();
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
      restrictWidth: 1200,
      pageHeader: {
        pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "home.tutorial.addDataToKibanaTitle",
          defaultMessage: "Add data",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 278,
            columnNumber: 13
          }
        }),
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "home.tutorial.addDataToKibanaDescription",
          defaultMessage: "Try our sample data or upload your own data.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 281,
            columnNumber: 13
          }
        }),
        tabs,
        rightSideItems: headerLinks ? [headerLinks] : []
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 9
      }
    }, this.renderTabContent()));
  }
}
const TutorialDirectory = exports.TutorialDirectory = (0, _i18nReact.injectI18n)(TutorialDirectoryUi);