"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionPanel = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_navigation_handler = require("../app_navigation_handler");
var _kibana_services = require("../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/solutions_section/solution_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getSolutionGraphicURL = solutionId => `/plugins/kibanaReact/assets/solutions_${solutionId}.svg`;
const SolutionPanel = ({
  addBasePath,
  solution
}) => {
  const {
    trackUiMetric
  } = (0, _kibana_services.getServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles,
    "data-test-subj": `homeSolutionPanel homeSolutionPanel_${solution.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    className: `homeSolutionPanel homeSolutionPanel--${solution.id}`,
    description: solution.description,
    href: addBasePath(solution.path),
    icon: /*#__PURE__*/_react.default.createElement(_public.KibanaPageTemplateSolutionNavAvatar, {
      name: solution.title,
      iconType: solution.icon,
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }),
    image: addBasePath(getSolutionGraphicURL((0, _lodash.snakeCase)(solution.id))),
    onClick: event => {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, `solution_panel_${solution.id}`);
      (0, _app_navigation_handler.createAppNavigationHandler)(solution.path)(event);
    },
    title: solution.title,
    titleElement: "h2",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }));
};
exports.SolutionPanel = SolutionPanel;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  [`@media (min-width: ${euiTheme.breakpoint.m}px)`]: {
    maxInlineSize: `calc(33.33% - ${euiTheme.size.m} * 10)`
  },
  '.homeSolutionPanel': {
    img: {
      backgroundColor: euiTheme.colors.primary,
      maxBlockSize: (0, _eui.mathWithUnits)(euiTheme.size.m, x => x * 10),
      objectFit: 'cover'
    },
    '&--enterpriseSearch img': {
      backgroundColor: euiTheme.colors.warning
    },
    '&--observability img': {
      backgroundColor: euiTheme.colors.accent
    },
    '&--securitySolution img': {
      backgroundColor: euiTheme.colors.accentSecondary
    }
  }
});