"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddData = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _move_data = require("../move_data");
var _setup_cloud_connect = require("../setup_cloud_connect");
var _app_navigation_handler = require("../app_navigation_handler");
var _kibana_services = require("../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/add_data/add_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const AddData = ({
  addBasePath,
  application,
  isDarkMode,
  isCloudEnabled
}) => {
  var _application$capabili, _application$capabili2;
  const {
    trackUiMetric
  } = (0, _kibana_services.getServices)();
  const euiBreakpointM = (0, _eui.useEuiMinBreakpoint)('m');
  const euiBreakpointL = (0, _eui.useEuiMinBreakpoint)('l');
  const styles = ({
    euiTheme
  }) => (0, _react2.css)({
    display: 'block',
    marginBlock: `0 -${(0, _eui.mathWithUnits)([euiTheme.size.xl, euiTheme.size.xs], (x, y) => x + y)}`,
    marginInline: 'auto',
    [euiBreakpointM]: {
      marginBlockEnd: euiTheme.size.xl
    },
    [euiBreakpointL]: {
      inlineSize: '80%'
    }
  });
  const canAccessIntegrations = application.capabilities.navLinks.integrations;
  const hasCloudConnectPermission = Boolean(((_application$capabili = application.capabilities.cloudConnect) === null || _application$capabili === void 0 ? void 0 : _application$capabili.show) || ((_application$capabili2 = application.capabilities.cloudConnect) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.configure));
  if (canAccessIntegrations) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      bottomBorder: true,
      paddingSize: "xl",
      "aria-labelledby": "homeDataAdd__title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "homeDataAdd__title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.sectionTitle",
      defaultMessage: "Get started by adding integrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.text",
      defaultMessage: "To start working with your data, use one of our many ingest options. Collect data from an app or service, or upload a file. If you're not ready to use your own data, play with a sample data set.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "homeAddData",
      fill: !hasCloudConnectPermission,
      href: addBasePath('/app/integrations/browse'),
      iconType: "plusInCircle",
      onClick: event => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'home_tutorial_directory');
        (0, _app_navigation_handler.createAppNavigationHandler)('/app/integrations/browse')(event);
      },
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.addDataButtonLabel",
      defaultMessage: "Add integrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "addSampleData",
      href: addBasePath('#/tutorial_directory/sampleData'),
      iconType: "documents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.sampleDataButtonLabel",
      defaultMessage: "Try sample data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "uploadFile",
      href: addBasePath('#/tutorial_directory/fileDataViz'),
      iconType: "importAction",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.uploadFileButtonLabel",
      defaultMessage: "Upload a file",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 11
      }
    }, !isCloudEnabled ? hasCloudConnectPermission ? /*#__PURE__*/_react.default.createElement(_setup_cloud_connect.SetupCloudConnect, {
      addBasePath: addBasePath,
      application: application,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_move_data.MoveData, {
      addBasePath: addBasePath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      alt: _i18n.i18n.translate('home.addData.illustration.alt.text', {
        defaultMessage: 'Illustration of Elastic data integrations'
      }),
      css: styles,
      src: addBasePath('/plugins/kibanaReact/assets/') + (isDarkMode ? 'illustration_integrations_darkmode.svg' : 'illustration_integrations_lightmode.svg'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 15
      }
    }))));
  } else {
    return null;
  }
};
exports.AddData = AddData;