"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentationSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _inferenceCommon = require("@kbn/inference-common");
var _productDocCommon = require("@kbn/product-doc-common");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/product-doc-base-plugin/public");
var _use_kibana = require("../../hooks/use_kibana");
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/documentation/documentation_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DocumentationSection = ({
  productDocBase
}) => {
  var _application$capabili;
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    notifications,
    application,
    rendering,
    docLinks
  } = services;

  // Check if user has Agent Builder 'All' privileges (manageAgents capability)
  const hasManagePrivilege = ((_application$capabili = application.capabilities.agentBuilder) === null || _application$capabili === void 0 ? void 0 : _application$capabili.manageAgents) === true;
  const {
    status: productDocsStatusResponse,
    isLoading: isLoadingProductDocs,
    refetch: refetchProductDocs
  } = (0, _public.useProductDocStatus)(productDocBase);
  const {
    status: securityLabsStatusResponse,
    isLoading: isLoadingSecurityLabs,
    refetch: refetchSecurityLabs
  } = (0, _public.useProductDocStatus)(productDocBase, {
    inferenceId: _inferenceCommon.defaultInferenceEndpoints.ELSER,
    resourceType: _productDocCommon.ResourceTypes.securityLabs
  });
  const isLoading = isLoadingProductDocs || isLoadingSecurityLabs;
  const refetch = (0, _react.useCallback)(() => {
    refetchProductDocs();
    refetchSecurityLabs();
  }, [refetchProductDocs, refetchSecurityLabs]);
  const installMutation = (0, _public.useInstallProductDoc)(productDocBase, {
    onSuccess: () => {
      notifications.toasts.addSuccess({
        title: i18n.INSTALL_SUCCESS
      });
    },
    onError: error => {
      var _error$body$message, _error$body;
      const message = (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message;
      notifications.toasts.addDanger({
        title: i18n.INSTALL_ERROR,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 81,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 13
          }
        }, message), /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 13
          }
        }, i18n.AIR_GAPPED_HINT), /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 84,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.aiAssistantSettings,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 15
          }
        }, i18n.LEARN_MORE))), rendering)
      });
    }
  });
  const {
    mutate: installDoc,
    isLoading: isInstalling
  } = installMutation;
  const uninstallMutation = (0, _public.useUninstallProductDoc)(productDocBase, {
    onSuccess: () => {
      notifications.toasts.addSuccess({
        title: i18n.UNINSTALL_SUCCESS
      });
    },
    onError: error => {
      var _error$body$message2, _error$body2;
      notifications.toasts.addError(new Error((_error$body$message2 = (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message2 !== void 0 ? _error$body$message2 : error.message), {
        title: i18n.UNINSTALL_ERROR
      });
    }
  });
  const {
    mutate: uninstallDoc,
    isLoading: isUninstalling
  } = uninstallMutation;
  const handleInstall = (0, _react.useCallback)(itemId => {
    if (itemId === _types.ELASTIC_DOCS_ID) {
      installDoc(_inferenceCommon.defaultInferenceEndpoints.ELSER);
    }
    if (itemId === _types.SECURITY_LABS_ID) {
      installDoc({
        inferenceId: _inferenceCommon.defaultInferenceEndpoints.ELSER,
        resourceType: _productDocCommon.ResourceTypes.securityLabs
      });
    }
  }, [installDoc]);
  const handleUninstall = (0, _react.useCallback)(itemId => {
    if (itemId === _types.ELASTIC_DOCS_ID) {
      uninstallDoc(_inferenceCommon.defaultInferenceEndpoints.ELSER);
    }
    if (itemId === _types.SECURITY_LABS_ID) {
      uninstallDoc({
        inferenceId: _inferenceCommon.defaultInferenceEndpoints.ELSER,
        resourceType: _productDocCommon.ResourceTypes.securityLabs
      });
    }
  }, [uninstallDoc]);
  const handleRetry = (0, _react.useCallback)(itemId => {
    handleInstall(itemId);
  }, [handleInstall]);
  const documentationItems = (0, _react.useMemo)(() => {
    var _ref, _ref2;
    const elasticDocsStatus = (_ref = productDocsStatusResponse && 'overall' in productDocsStatusResponse ? productDocsStatusResponse.overall : 'uninstalled') !== null && _ref !== void 0 ? _ref : 'uninstalled';
    const securityLabsStatus = (_ref2 = securityLabsStatusResponse && 'status' in securityLabsStatusResponse ? securityLabsStatusResponse.status : 'uninstalled') !== null && _ref2 !== void 0 ? _ref2 : 'uninstalled';
    const securityLabsUpdateAvailable = securityLabsStatusResponse && 'isUpdateAvailable' in securityLabsStatusResponse && Boolean(securityLabsStatusResponse.isUpdateAvailable);
    return [{
      id: _types.ELASTIC_DOCS_ID,
      name: i18n.ELASTIC_DOCS_NAME,
      status: elasticDocsStatus,
      isTechPreview: false,
      isStubbed: false,
      icon: 'logoElastic'
    }, {
      id: _types.SECURITY_LABS_ID,
      name: i18n.SECURITY_LABS_NAME,
      status: securityLabsStatus,
      updateAvailable: securityLabsUpdateAvailable,
      isTechPreview: false,
      isStubbed: false,
      icon: 'logoSecurity'
    }];
  }, [productDocsStatusResponse, securityLabsStatusResponse]);
  const getStatusBadge = (0, _react.useCallback)(itemStatus => {
    // Status badge only shows binary state: Installed or Not installed
    // Action states (installing/uninstalling) are shown in the action button
    switch (itemStatus) {
      case 'installed':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "success",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 186,
            columnNumber: 16
          }
        }, i18n.STATUS_INSTALLED);
      case 'uninstalling':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "success",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 16
          }
        }, i18n.STATUS_INSTALLED);
      case 'error':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 190,
            columnNumber: 16
          }
        }, i18n.STATUS_ERROR);
      case 'not_available':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "warning",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 192,
            columnNumber: 16
          }
        }, i18n.STATUS_NOT_AVAILABLE);
      case 'installing':
      case 'uninstalled':
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 16
          }
        }, i18n.STATUS_NOT_INSTALLED);
    }
  }, []);
  const getActionButton = (0, _react.useCallback)(item => {
    const installItemId = installMutation.variables && typeof installMutation.variables === 'object' ? installMutation.variables.resourceType === _productDocCommon.ResourceTypes.securityLabs ? _types.SECURITY_LABS_ID : _types.ELASTIC_DOCS_ID : _types.ELASTIC_DOCS_ID;
    const uninstallItemId = uninstallMutation.variables && typeof uninstallMutation.variables === 'object' ? uninstallMutation.variables.resourceType === _productDocCommon.ResourceTypes.securityLabs ? _types.SECURITY_LABS_ID : _types.ELASTIC_DOCS_ID : _types.ELASTIC_DOCS_ID;

    // Use server status OR local mutation state to determine if action is in progress
    const isItemInstalling = item.status === 'installing' || isInstalling && item.id === installItemId;
    const isItemUninstalling = item.status === 'uninstalling' || isUninstalling && item.id === uninstallItemId;

    // Helper to wrap button with tooltip when user lacks privileges
    const wrapWithPrivilegeTooltip = button => {
      if (!hasManagePrivilege) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: i18n.INSUFFICIENT_PRIVILEGES,
          position: "top",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 226,
            columnNumber: 13
          }
        }, button);
      }
      return button;
    };

    // Stubbed items show disabled install button
    if (item.isStubbed && item.status !== 'not_available') {
      return wrapWithPrivilegeTooltip(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "download",
        isDisabled: true,
        "data-test-subj": `documentation-install-${item.id}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 11
        }
      }, i18n.ACTION_INSTALL));
    }

    // Not available - show retry
    if (item.status === 'not_available') {
      return wrapWithPrivilegeTooltip(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "refresh",
        onClick: hasManagePrivilege ? () => refetch() : undefined,
        isDisabled: !hasManagePrivilege,
        "data-test-subj": `documentation-retry-${item.id}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 251,
          columnNumber: 11
        }
      }, i18n.ACTION_RETRY));
    }

    // Error state - show retry
    if (item.status === 'error') {
      return wrapWithPrivilegeTooltip(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "refresh",
        onClick: hasManagePrivilege ? () => handleRetry(item.id) : undefined,
        isDisabled: !hasManagePrivilege,
        "data-test-subj": `documentation-retry-${item.id}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 11
        }
      }, i18n.ACTION_RETRY));
    }

    // Uninstalling - show loading state
    if (isItemUninstalling) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        isLoading: true,
        isDisabled: true,
        "data-test-subj": `documentation-uninstalling-${item.id}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 11
        }
      }, i18n.STATUS_UNINSTALLING);
    }

    // Installed - show uninstall button
    if (item.status === 'installed') {
      if (item.updateAvailable) {
        return wrapWithPrivilegeTooltip(/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          justifyContent: "flexEnd",
          responsive: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 296,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 302,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          size: "xs",
          iconType: "refresh",
          onClick: hasManagePrivilege ? () => handleInstall(item.id) : undefined,
          isDisabled: !hasManagePrivilege,
          "data-test-subj": `documentation-update-${item.id}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 303,
            columnNumber: 17
          }
        }, i18n.ACTION_UPDATE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 313,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          size: "xs",
          iconType: "returnKey",
          onClick: hasManagePrivilege ? () => handleUninstall(item.id) : undefined,
          isDisabled: !hasManagePrivilege,
          "data-test-subj": `documentation-uninstall-${item.id}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 314,
            columnNumber: 17
          }
        }, i18n.ACTION_UNINSTALL))));
      }
      return wrapWithPrivilegeTooltip(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "returnKey",
        onClick: hasManagePrivilege ? () => handleUninstall(item.id) : undefined,
        isDisabled: !hasManagePrivilege,
        "data-test-subj": `documentation-uninstall-${item.id}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 11
        }
      }, i18n.ACTION_UNINSTALL));
    }

    // Installing - show loading state
    if (isItemInstalling) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        isLoading: true,
        isDisabled: true,
        "data-test-subj": `documentation-installing-${item.id}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 344,
          columnNumber: 11
        }
      }, i18n.STATUS_INSTALLING);
    }

    // Default - show install button
    return wrapWithPrivilegeTooltip(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "download",
      onClick: hasManagePrivilege ? () => handleInstall(item.id) : undefined,
      isDisabled: !hasManagePrivilege,
      "data-test-subj": `documentation-install-${item.id}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 357,
        columnNumber: 9
      }
    }, i18n.ACTION_INSTALL));
  }, [handleInstall, handleUninstall, handleRetry, isInstalling, isUninstalling, refetch, hasManagePrivilege, installMutation.variables, uninstallMutation.variables]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: i18n.COLUMN_NAME,
    sortable: false,
    render: (name, item) => {
      var _item$icon;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 388,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 389,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: (_item$icon = item.icon) !== null && _item$icon !== void 0 ? _item$icon : 'documents',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 390,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 15
        }
      }, name)), item.isTechPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 396,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        label: i18n.TECH_PREVIEW,
        size: "s",
        alignment: "middle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 17
        }
      })), item.updateAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 401,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 402,
          columnNumber: 17
        }
      }, i18n.UPDATE_AVAILABLE)));
    }
  }, {
    field: 'status',
    name: i18n.COLUMN_STATUS,
    sortable: false,
    width: '300px',
    render: itemStatus => getStatusBadge(itemStatus)
  }, {
    field: 'actions',
    name: i18n.COLUMN_ACTIONS,
    sortable: false,
    width: '150px',
    align: 'right',
    render: (_, item) => getActionButton(item)
  }], [getStatusBadge, getActionButton]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    grow: false,
    "data-test-subj": "documentationSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": "documentationTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 11
    }
  }, i18n.DOCUMENTATION_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 9
    }
  }, i18n.DOCUMENTATION_DESCRIPTION, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.aiAssistantSettings,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 11
    }
  }, i18n.LEARN_MORE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 9
    }
  }, i18n.SHOWING, " ", /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 26
    }
  }, "1-", documentationItems.length), " ", i18n.OF, ' ', documentationItems.length, " ", /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 444,
      columnNumber: 39
    }
  }, i18n.DOCUMENTATION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: documentationItems,
    columns: columns,
    loading: isLoading,
    "data-test-subj": "documentationTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 9
    }
  })));
};
exports.DocumentationSection = DocumentationSection;