"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrollmentAPIKeySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnrollmentAPIKeySchema = exports.EnrollmentAPIKeySchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  api_key_id: _configSchema.schema.string({
    meta: {
      description: 'The ID of the API key in the Security API.'
    }
  }),
  api_key: _configSchema.schema.string({
    meta: {
      description: 'The enrollment API key (token) used for enrolling Elastic Agents.'
    }
  }),
  name: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The name of the enrollment API key.'
    }
  })),
  active: _configSchema.schema.boolean({
    meta: {
      description: 'When false, the enrollment API key is revoked and cannot be used for enrolling Elastic Agents.'
    }
  }),
  policy_id: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The ID of the agent policy the Elastic Agent will be enrolled in.'
    }
  })),
  created_at: _configSchema.schema.string(),
  hidden: _configSchema.schema.maybe(_configSchema.schema.boolean())
});