"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runMigrateComponentTemplateILMs = runMigrateComponentTemplateILMs;
var _services = require("../../services");
var _default_settings = require("../../services/epm/elasticsearch/template/default_settings");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runMigrateComponentTemplateILMs(params) {
  var _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const {
    logger,
    abortController
  } = params;
  const isILMPoliciesDisabled = (_appContextService$ge = (_appContextService$ge2 = _services.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.disableILMPolicies) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  if (isILMPoliciesDisabled) {
    return;
  }
  const esClient = _services.appContextService.getInternalUserESClient();
  const ilmMigrationStatusMap = await (0, _default_settings.getILMMigrationStatus)();
  const updatedILMMigrationStatusMap = new Map(ilmMigrationStatusMap);
  const ilmPolicies = await (0, _default_settings.getILMPolicies)(_default_settings.DATA_STREAM_TYPES_DEPRECATED_ILMS);
  for (const dataStreamType of _default_settings.DATA_STREAM_TYPES_DEPRECATED_ILMS) {
    var _ilmPolicy$deprecated, _ilmPolicy$deprecated2, _ilmPolicy$newILMPoli, _ilmPolicy$newILMPoli2;
    (0, _utils.throwIfAborted)(abortController);
    const ilmPolicy = ilmPolicies.get(dataStreamType);
    // Migrate existing component templates if none of the ILM policies are modified or the migration was already done
    if ((((_ilmPolicy$deprecated = ilmPolicy === null || ilmPolicy === void 0 ? void 0 : (_ilmPolicy$deprecated2 = ilmPolicy.deprecatedILMPolicy) === null || _ilmPolicy$deprecated2 === void 0 ? void 0 : _ilmPolicy$deprecated2.version) !== null && _ilmPolicy$deprecated !== void 0 ? _ilmPolicy$deprecated : 1) > 1 || ((_ilmPolicy$newILMPoli = ilmPolicy === null || ilmPolicy === void 0 ? void 0 : (_ilmPolicy$newILMPoli2 = ilmPolicy.newILMPolicy) === null || _ilmPolicy$newILMPoli2 === void 0 ? void 0 : _ilmPolicy$newILMPoli2.version) !== null && _ilmPolicy$newILMPoli !== void 0 ? _ilmPolicy$newILMPoli : 1) > 1) && ilmMigrationStatusMap.get(dataStreamType) !== 'success') {
      continue;
    }
    const componentTemplates = await esClient.cluster.getComponentTemplate({
      name: `${dataStreamType}-*@package`
    }, {
      ignore: [404]
    });
    for (const [, componentTemplate] of Object.entries(componentTemplates.component_templates)) {
      var _componentTemplate$co, _settings$index$lifec;
      (0, _utils.throwIfAborted)(abortController);
      const settings = (_componentTemplate$co = componentTemplate.component_template.template.settings) !== null && _componentTemplate$co !== void 0 ? _componentTemplate$co : {};
      if (((_settings$index$lifec = settings.index.lifecycle) === null || _settings$index$lifec === void 0 ? void 0 : _settings$index$lifec.name) === dataStreamType) {
        logger.info(`Component template ${componentTemplate.name} uses deprecated ILM policy, migrating to ${dataStreamType}@lifecycle`);
        await updateComponentTemplate(esClient, componentTemplate, dataStreamType);
        updatedILMMigrationStatusMap.set(dataStreamType, 'success');
      }
    }
  }
  await (0, _default_settings.saveILMMigrationChanges)(updatedILMMigrationStatusMap);
}
async function updateComponentTemplate(esClient, componentTemplate, dataStreamType) {
  var _componentTemplate$co2;
  const settings = (_componentTemplate$co2 = componentTemplate.component_template.template.settings) !== null && _componentTemplate$co2 !== void 0 ? _componentTemplate$co2 : {};
  await esClient.cluster.putComponentTemplate({
    name: componentTemplate.name,
    template: {
      ...componentTemplate.component_template.template,
      settings: {
        ...settings,
        index: {
          ...settings.index,
          lifecycle: {
            ...settings.index.lifecycle,
            name: `${dataStreamType}@lifecycle`
          }
        }
      }
    }
  });
}