"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerReindexIntegrationKnowledgeTask = registerReindexIntegrationKnowledgeTask;
exports.reindexIntegrationKnowledgeForInstalledPackages = reindexIntegrationKnowledgeForInstalledPackages;
exports.scheduleReindexIntegrationKnowledgeTask = scheduleReindexIntegrationKnowledgeTask;
var _uuid = require("uuid");
var _pMap = _interopRequireDefault(require("p-map"));
var Registry = _interopRequireWildcard(require("../services/epm/registry"));
var _packages = require("../services/epm/packages");
var _services = require("../services");
var _constants = require("../constants");
var _steps = require("../services/epm/packages/install_state_machine/steps");
var _archive = require("../services/epm/archive");
var _bundled_packages = require("../services/epm/packages/bundled_packages");
var _install = require("../services/epm/packages/install");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TASK_TYPE = 'fleet:reindex_integration_knowledge';
function registerReindexIntegrationKnowledgeTask(taskManagerSetup) {
  taskManagerSetup.registerTaskDefinitions({
    [TASK_TYPE]: {
      title: 'Fleet Reindex integration knowledge',
      timeout: '5m',
      maxAttempts: 3,
      createTaskRunner: ({
        abortController
      }) => {
        return {
          async run() {
            // Check if user has appropriate license for knowledge base functionality
            if (!_services.licenseService.isEnterprise()) {
              _services.appContextService.getLogger().debug(`Skipping knowledge base reindexing - requires Enterprise license`);
              return;
            }
            await reindexIntegrationKnowledgeForInstalledPackages(abortController);
          }
        };
      }
    }
  });
}
async function scheduleReindexIntegrationKnowledgeTask(taskManagerStart) {
  _services.appContextService.getLogger().info('Scheduling task to reindex integration knowledge for installed packages');
  await taskManagerStart.ensureScheduled({
    id: `${TASK_TYPE}:${(0, _uuid.v4)()}`,
    scope: ['fleet'],
    params: {},
    taskType: TASK_TYPE,
    runAt: new Date(),
    state: {}
  });
}
async function reindexIntegrationKnowledgeForInstalledPackages(abortController) {
  const soClient = _services.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  const esClient = _services.appContextService.getInternalUserESClient();
  const logger = _services.appContextService.getLogger();
  const installedPackages = await (0, _packages.getInstallations)(soClient);
  await (0, _pMap.default)(installedPackages.saved_objects, async ({
    attributes: installation
  }) => {
    (0, _utils.throwIfAborted)(abortController);
    const knowledgeBase = await (0, _packages.getPackageKnowledgeBase)({
      esClient,
      pkgName: installation.name,
      abortController
    });
    const everyKnowledgeBaseOnCurrentPackageVersion = knowledgeBase === null || knowledgeBase === void 0 ? void 0 : knowledgeBase.items.every(item => item.version === installation.version);
    if (everyKnowledgeBaseOnCurrentPackageVersion) {
      logger.debug(`Skipping reindexing knowledge base for package ${installation.name}@${installation.version} - already indexed`);
      return;
    }
    let archiveIterator;
    if (installation.install_source === 'bundled') {
      const matchingBundledPackage = await (0, _bundled_packages.getBundledPackageForInstallation)(installation);
      if (!matchingBundledPackage) {
        logger.debug(`Skipping reindexing knowledge base for package ${installation.name}@${installation.version} - bundled package not found`);
        return;
      }
      const useStreaming = _install.PACKAGES_TO_INSTALL_WITH_STREAMING.includes(installation.name);
      const archiveBuffer = await matchingBundledPackage.getBuffer();
      ({
        archiveIterator
      } = await (0, _archive.unpackBufferToAssetsMap)({
        archiveBuffer,
        contentType: 'application/zip',
        useStreaming
      }));
    } else if (installation.install_source !== 'registry') {
      logger.debug(`Skipping reindexing knowledge base for package ${installation.name}@${installation.version} - install source ${installation.install_source}`);
      return;
    }
    if (installation.install_source === 'registry') {
      ({
        archiveIterator
      } = await Registry.getPackage(installation.name, installation.version, {
        useStreaming: true
      }));
    }
    await (0, _steps.indexKnowledgeBase)(installation.installed_es, soClient, esClient, logger, {
      name: installation.name,
      version: installation.version
    }, archiveIterator, abortController).catch(error => {
      logger.error(`Failed reindexing knowledge base for package ${installation.name}@${installation.version}: ${error}`);
    });
  }, {
    concurrency: _constants.MAX_CONCURRENT_EPM_PACKAGES_INSTALLATIONS
  });
}