"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._runBulkUninstallTask = _runBulkUninstallTask;
exports.scheduleBulkUninstall = scheduleBulkUninstall;
var _packages = require("../../services/epm/packages");
var _services = require("../../services");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function _runBulkUninstallTask({
  abortController,
  taskParams,
  logger
}) {
  const {
    packages,
    force
  } = taskParams;
  const esClient = _services.appContextService.getInternalUserESClient();
  const savedObjectsClient = _services.appContextService.getInternalUserSOClient();
  const results = [];
  for (const pkg of packages) {
    // Throw between package uninstall if task is aborted
    if (abortController.signal.aborted) {
      throw new Error('Task was aborted');
    }
    try {
      await (0, _packages.removeInstallation)({
        savedObjectsClient,
        pkgName: pkg.name,
        pkgVersion: pkg.version,
        esClient,
        force
      });
      results.push({
        name: pkg.name,
        success: true
      });
    } catch (error) {
      logger.error(`Uninstalling package: ${pkg.name} failed`, {
        error
      });
      results.push({
        name: pkg.name,
        success: false,
        error: (0, _utils.formatError)(error)
      });
    }
  }
  return results;
}
async function scheduleBulkUninstall(taskManagerStart, taskParams) {
  return (0, _utils.scheduleBulkOperationTask)(taskManagerStart, {
    ...taskParams,
    type: 'bulk_uninstall'
  });
}