"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updatePackagePolicySpaces = updatePackagePolicySpaces;
var _constants = require("../../../common/constants");
var _app_context = require("../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updatePackagePolicySpaces({
  packagePolicyId,
  currentSpaceId,
  newSpaceIds
}) {
  const soClientWithoutSpaceExtension = _app_context.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  const results = await soClientWithoutSpaceExtension.updateObjectsSpaces([{
    id: packagePolicyId,
    type: _constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE
  }], newSpaceIds, newSpaceIds.length === 1 && newSpaceIds[0] === _constants.ALL_SPACES_ID ? [currentSpaceId] : [], {
    refresh: 'wait_for',
    namespace: currentSpaceId
  });
  for (const soRes of results.objects) {
    if (soRes.error) {
      throw soRes.error;
    }
  }
}