"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.incrementPackageName = incrementPackageName;
exports.incrementPackagePolicyCopyName = incrementPackagePolicyCopyName;
var _constants = require("../../../common/constants");
var _services = require("../../../common/services");
var _constants2 = require("../../constants");
var _package_policy = require("../package_policy");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function incrementPackageName(soClient, packageName, spaceIds) {
  const isMultiSpace = spaceIds.length > 1;
  const baseSearchParams = {
    perPage: _constants.SO_SEARCH_LIMIT,
    kuery: `${_constants2.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: "${packageName}"`
  };

  // Fetch all packagePolicies having the package name
  let packagePoliciesResult;
  if (isMultiSpace) {
    packagePoliciesResult = await _package_policy.packagePolicyService.list(_.appContextService.getInternalUserSOClientWithoutSpaceExtension(), {
      ...baseSearchParams,
      spaceId: '*'
    });
  } else {
    packagePoliciesResult = await _package_policy.packagePolicyService.list(soClient, baseSearchParams);
  }
  const packagePolicies = isMultiSpace ? packagePoliciesResult.items.filter(packagePolicy => {
    var _packagePolicy$spaceI;
    return (_packagePolicy$spaceI = packagePolicy.spaceIds) === null || _packagePolicy$spaceI === void 0 ? void 0 : _packagePolicy$spaceI.some(spaceId => spaceIds.includes(spaceId));
  }) : packagePoliciesResult.items;
  return (0, _services.getMaxPackageName)(packageName, packagePolicies);
}
async function incrementPackagePolicyCopyName(soClient, packagePolicyName) {
  let packageName = packagePolicyName;
  const packageNameMatches = packagePolicyName.match(/^(.*)\s\(copy\s?[0-9]*\)$/);
  if (packageNameMatches) {
    packageName = packageNameMatches[1];
  }

  // find all pacakge policies starting with the same name and increment the name
  const packagePolicyData = await _package_policy.packagePolicyService.list(soClient, {
    perPage: _constants.SO_SEARCH_LIMIT,
    // split package name on first space as KQL do not support wildcard and space
    kuery: `${_constants2.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.name: ${packageName.split(' ')[0]}*`
  });
  const maxVersion = packagePolicyData.items.length > 0 ? Math.max(...packagePolicyData.items.filter(item => item.name.startsWith(packageName)).map(item => {
    const matches = item.name.match(/^(.*)\s\(copy\s?([0-9]*)\)$/);
    if (matches) {
      return parseInt(matches[2], 10) || 1;
    }
    return 0;
  })) : 0;
  const copyVersion = maxVersion + 1;
  if (copyVersion === 1) {
    return `${packageName} (copy)`;
  }
  return `${packageName} (copy ${copyVersion})`;
}