"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultPipeline = void 0;
var _jsYaml = require("js-yaml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE: The install methods will take care of adding a reference to a @custom pipeline. We don't need to add one here.
const createDefaultPipeline = (dataset, type) => {
  const pipeline = {
    processors: [{
      set: {
        description: "If '@timestamp' is missing, set it with the ingest timestamp",
        field: '@timestamp',
        override: false,
        copy_from: '_ingest.timestamp'
      }
    }],
    _meta: {
      description: `default pipeline for the ${dataset} dataset`,
      managed: true
    }
  };
  return (0, _jsYaml.dump)(pipeline);
};
exports.createDefaultPipeline = createDefaultPipeline;