"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putSpaceSettingsHandler = exports.putSettingsHandler = exports.getSpaceSettingsHandler = exports.getSettingsHandler = void 0;
var _services = require("../../services");
var _space_settings = require("../../services/spaces/space_settings");
var _reindex_integration_knowledge_task = require("../../tasks/reindex_integration_knowledge_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSpaceSettingsHandler = async (context, request, response) => {
  const soClient = (await context.fleet).internalSoClient;
  const settings = await (0, _space_settings.getSpaceSettings)(soClient.getCurrentNamespace());
  const body = {
    item: settings
  };
  return response.ok({
    body
  });
};
exports.getSpaceSettingsHandler = getSpaceSettingsHandler;
const putSpaceSettingsHandler = async (context, request, response) => {
  const soClient = (await context.fleet).internalSoClient;
  await (0, _space_settings.saveSpaceSettings)({
    settings: {
      allowed_namespace_prefixes: request.body.allowed_namespace_prefixes
    },
    spaceId: soClient.getCurrentNamespace()
  });
  const settings = await (0, _space_settings.getSpaceSettings)(soClient.getCurrentNamespace());
  const body = {
    item: settings
  };
  return response.ok({
    body
  });
};
exports.putSpaceSettingsHandler = putSpaceSettingsHandler;
const getSettingsHandler = async (context, request, response) => {
  const soClient = (await context.fleet).internalSoClient;
  try {
    const settings = await _services.settingsService.getSettings(soClient);
    const body = {
      item: settings
    };
    return response.ok({
      body
    });
  } catch (error) {
    if (error.isBoom && error.output.statusCode === 404) {
      return response.notFound({
        body: {
          message: `Settings not found`
        }
      });
    }
    throw error;
  }
};
exports.getSettingsHandler = getSettingsHandler;
const putSettingsHandler = async (context, request, response) => {
  const soClient = (await context.fleet).internalSoClient;
  try {
    const settings = await _services.settingsService.saveSettings(soClient, request.body);
    if (request.body.integration_knowledge_enabled) {
      await (0, _reindex_integration_knowledge_task.scheduleReindexIntegrationKnowledgeTask)(_services.appContextService.getTaskManagerStart());
    }
    const body = {
      item: settings
    };
    return response.ok({
      body
    });
  } catch (error) {
    if (error.isBoom && error.output.statusCode === 404) {
      return response.notFound({
        body: {
          message: `Settings not found`
        }
      });
    }
    throw error;
  }
};
exports.putSettingsHandler = putSettingsHandler;