"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetStatusProvider = void 0;
exports.useFleetStatus = useFleetStatus;
var _react = _interopRequireWildcard(require("react"));
var _use_core = require("./use_core");
var _use_config = require("./use_config");
var _use_request = require("./use_request");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/hooks/use_fleet_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FleetStatusContext = /*#__PURE__*/_react.default.createContext(undefined);
const FleetStatusProvider = ({
  defaultFleetStatus,
  children
}) => {
  var _ref, _ref2;
  const config = (0, _use_config.useConfig)();
  const {
    spaces
  } = (0, _use_core.useStartServices)();
  const [spaceId, setSpaceId] = (0, _react.useState)();
  const [forceDisplayInstructions, setForceDisplayInstructions] = (0, _react.useState)(false);
  const {
    data,
    isLoading,
    refetch
  } = (0, _use_request.useGetFleetStatusQuery)();
  (0, _react.useEffect)(() => {
    const getSpace = async () => {
      if (spaces) {
        const space = await spaces.getActiveSpace();
        setSpaceId(space.id);
      }
    };
    getSpace();
  }, [spaces]);
  const state = {
    ...defaultFleetStatus,
    enabled: config.agents.enabled,
    isLoading,
    isReady: (_ref = (_ref2 = !isLoading && (data === null || data === void 0 ? void 0 : data.isReady)) !== null && _ref2 !== void 0 ? _ref2 : defaultFleetStatus === null || defaultFleetStatus === void 0 ? void 0 : defaultFleetStatus.isReady) !== null && _ref !== void 0 ? _ref : false,
    missingRequirements: data === null || data === void 0 ? void 0 : data.missing_requirements,
    missingOptionalFeatures: data === null || data === void 0 ? void 0 : data.missing_optional_features,
    isSecretsStorageEnabled: data === null || data === void 0 ? void 0 : data.is_secrets_storage_enabled,
    isSpaceAwarenessEnabled: data === null || data === void 0 ? void 0 : data.is_space_awareness_enabled,
    isSSLSecretsStorageEnabled: data === null || data === void 0 ? void 0 : data.is_ssl_secrets_storage_enabled,
    isActionSecretsStorageEnabled: data === null || data === void 0 ? void 0 : data.is_action_secrets_storage_enabled,
    spaceId
  };
  return /*#__PURE__*/_react.default.createElement(FleetStatusContext.Provider, {
    value: {
      ...state,
      refetch,
      forceDisplayInstructions,
      setForceDisplayInstructions
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, children);
};
exports.FleetStatusProvider = FleetStatusProvider;
function useFleetStatus() {
  const context = (0, _react.useContext)(FleetStatusContext);
  if (!context) {
    throw new Error('FleetStatusContext not set');
  }
  return context;
}